/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.zookeeper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.EventType;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;
import org.apache.zookeeper.data.Stat;

public class ZookeeperMetadataReport
extends AbstractMetadataReport {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ZookeeperMetadataReport.class);
    private final String root;
    ZookeeperClient zkClient;
    private ConcurrentMap<String, MappingDataListener> casListenerMap = new ConcurrentHashMap<String, MappingDataListener>();

    public ZookeeperMetadataReport(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getGroup("dubbo");
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.zkClient = zookeeperTransporter.connect(url);
    }

    protected String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }

    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    protected void doSaveMetadata(ServiceMetadataIdentifier metadataIdentifier, URL url) {
        this.zkClient.createOrUpdate(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier), URL.encode((String)url.toFullString()), false);
    }

    protected void doRemoveMetadata(ServiceMetadataIdentifier metadataIdentifier) {
        this.zkClient.delete(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier));
    }

    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.zkClient.getContent(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier));
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Collections.singletonList(URL.decode((String)content)));
    }

    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urls) {
        this.zkClient.createOrUpdate(this.getNodePath((BaseMetadataIdentifier)subscriberMetadataIdentifier), urls, false);
    }

    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.zkClient.getContent(this.getNodePath((BaseMetadataIdentifier)subscriberMetadataIdentifier));
    }

    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.zkClient.getContent(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier));
    }

    private void storeMetadata(MetadataIdentifier metadataIdentifier, String v) {
        this.zkClient.createOrUpdate(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier), v, false);
    }

    String getNodePath(BaseMetadataIdentifier metadataIdentifier) {
        return this.toRootDir() + metadataIdentifier.getUniqueKey(KeyTypeEnum.PATH);
    }

    public void publishAppMetadata(SubscriberMetadataIdentifier identifier, MetadataInfo metadataInfo) {
        String path = this.getNodePath((BaseMetadataIdentifier)identifier);
        if (StringUtils.isBlank((CharSequence)this.zkClient.getContent(path)) && StringUtils.isNotEmpty((String)metadataInfo.getContent())) {
            this.zkClient.createOrUpdate(path, metadataInfo.getContent(), false);
        }
    }

    public void unPublishAppMetadata(SubscriberMetadataIdentifier identifier, MetadataInfo metadataInfo) {
        String path = this.getNodePath((BaseMetadataIdentifier)identifier);
        if (StringUtils.isNotEmpty((String)this.zkClient.getContent(path))) {
            this.zkClient.delete(path);
        }
    }

    public MetadataInfo getAppMetadata(SubscriberMetadataIdentifier identifier, Map<String, String> instanceMetadata) {
        String content = this.zkClient.getContent(this.getNodePath((BaseMetadataIdentifier)identifier));
        return (MetadataInfo)JsonUtils.toJavaObject((String)content, MetadataInfo.class);
    }

    public Set<String> getServiceAppMapping(String serviceKey, MappingListener listener, URL url) {
        String path = this.buildPathKey("mapping", serviceKey);
        MappingDataListener mappingDataListener = (MappingDataListener)ConcurrentHashMapUtils.computeIfAbsent(this.casListenerMap, (Object)path, _k -> {
            MappingDataListener newMappingListener = new MappingDataListener(serviceKey, path);
            this.zkClient.addDataListener(path, (DataListener)newMappingListener);
            return newMappingListener;
        });
        mappingDataListener.addListener(listener);
        return ServiceNameMapping.getAppNames((String)this.zkClient.getContent(path));
    }

    public void removeServiceAppMappingListener(String serviceKey, MappingListener listener) {
        String path = this.buildPathKey("mapping", serviceKey);
        if (null != this.casListenerMap.get(path)) {
            this.removeCasServiceMappingListener(path, listener);
        }
    }

    public Set<String> getServiceAppMapping(String serviceKey, URL url) {
        String path = this.buildPathKey("mapping", serviceKey);
        return ServiceNameMapping.getAppNames((String)this.zkClient.getContent(path));
    }

    public ConfigItem getConfigItem(String serviceKey, String group) {
        String path = this.buildPathKey(group, serviceKey);
        return this.zkClient.getConfigItem(path);
    }

    public boolean registerServiceAppMapping(String key, String group, String content, Object ticket) {
        try {
            if (ticket != null && !(ticket instanceof Stat)) {
                throw new IllegalArgumentException("zookeeper publishConfigCas requires stat type ticket");
            }
            String pathKey = this.buildPathKey(group, key);
            this.zkClient.createOrUpdate(pathKey, content, false, ticket == null ? null : Integer.valueOf(((Stat)ticket).getVersion()));
            return true;
        }
        catch (Exception e) {
            logger.warn("1-35", "", "", "zookeeper publishConfigCas failed.", (Throwable)e);
            return false;
        }
    }

    public void destroy() {
        super.destroy();
        this.zkClient = null;
    }

    private String buildPathKey(String group, String serviceKey) {
        return this.toRootDir() + group + "/" + serviceKey;
    }

    private void removeCasServiceMappingListener(String path, MappingListener listener) {
        MappingDataListener mappingDataListener = (MappingDataListener)this.casListenerMap.get(path);
        mappingDataListener.removeListener(listener);
        if (mappingDataListener.isEmpty()) {
            this.zkClient.removeDataListener(path, (DataListener)mappingDataListener);
            this.casListenerMap.remove(path, mappingDataListener);
        }
    }

    private static class MappingDataListener
    implements DataListener {
        private String serviceKey;
        private String path;
        private Set<MappingListener> listeners;

        public MappingDataListener(String serviceKey, String path) {
            this.serviceKey = serviceKey;
            this.path = path;
            this.listeners = new HashSet<MappingListener>();
        }

        public void addListener(MappingListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(MappingListener listener) {
            this.listeners.remove(listener);
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void dataChanged(String path, Object value, EventType eventType) {
            if (!this.path.equals(path)) {
                return;
            }
            if (EventType.NodeCreated != eventType && EventType.NodeDataChanged != eventType) {
                return;
            }
            Set apps = ServiceNameMapping.getAppNames((String)((String)value));
            MappingChangedEvent event = new MappingChangedEvent(this.serviceKey, apps);
            this.listeners.forEach(mappingListener -> mappingListener.onEvent(event));
        }
    }
}

