/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.report.AbstractMetricsExport;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ApplicationStatComposite
extends AbstractMetricsExport {
    private final Map<MetricsKey, AtomicLong> applicationNumStats = new ConcurrentHashMap<MetricsKey, AtomicLong>();

    public ApplicationStatComposite(ApplicationModel applicationModel) {
        super(applicationModel);
    }

    public void init(List<MetricsKey> appKeys) {
        if (CollectionUtils.isEmpty(appKeys)) {
            return;
        }
        appKeys.forEach(appKey -> this.applicationNumStats.put((MetricsKey)((Object)appKey), new AtomicLong(0L)));
    }

    public void incrementSize(MetricsKey metricsKey, int size) {
        if (!this.applicationNumStats.containsKey((Object)metricsKey)) {
            return;
        }
        this.applicationNumStats.get((Object)metricsKey).getAndAdd(size);
    }

    @Override
    public List<MetricSample> export(MetricsCategory category) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        for (MetricsKey type : this.applicationNumStats.keySet()) {
            list.add(this.convertToSample(type, category, this.applicationNumStats.get((Object)type)));
        }
        return list;
    }

    private GaugeMetricSample convertToSample(MetricsKey type, MetricsCategory category, AtomicLong targetNumber) {
        return new GaugeMetricSample<AtomicLong>(type, MetricsSupport.applicationTags(this.getApplicationModel()), category, targetNumber, AtomicLong::get);
    }

    public Map<MetricsKey, AtomicLong> getApplicationNumStats() {
        return this.applicationNumStats;
    }
}

