/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.event.RequestEvent;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

@Activate(group={"consumer", "provider"}, order=-2147483548)
public class MetricsFilter
implements Filter,
BaseFilter.Listener,
ScopeModelAware {
    private ApplicationModel applicationModel;
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(MetricsFilter.class);

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            RequestEvent requestEvent = RequestEvent.toRequestEvent(this.applicationModel, invocation);
            MetricsEventBus.before((MetricsEvent)requestEvent, () -> invocation.put((Object)"metric_filter_event", (Object)requestEvent));
        }
        catch (Throwable t) {
            LOGGER.warn("99-0", "", "", "Error occurred when invoke.", t);
        }
        return invoker.invoke(invocation);
    }

    public void onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        Object eventObj = invocation.get((Object)"metric_filter_event");
        if (eventObj != null) {
            try {
                MetricsEventBus.after((MetricsEvent)((RequestEvent)((Object)eventObj)), (Object)result);
            }
            catch (Throwable t) {
                LOGGER.warn("99-0", "", "", "Error occurred when onResponse.", t);
            }
        }
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        Object eventObj = invocation.get((Object)"metric_filter_event");
        if (eventObj != null) {
            try {
                RequestEvent requestEvent = (RequestEvent)((Object)eventObj);
                requestEvent.putAttachment("metric_filter_throwable", t);
                MetricsEventBus.error((MetricsEvent)requestEvent);
            }
            catch (Throwable throwable) {
                LOGGER.warn("99-0", "", "", "Error occurred when onResponse.", throwable);
            }
        }
    }
}

