/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.ServiceInstance;

public class OverrideInstanceAddressURL
extends InstanceAddressURL {
    private static final long serialVersionUID = 6015101839312074851L;
    private final Map<String, String> overrideParams;
    private final InstanceAddressURL originUrl;
    private final transient Map<String, Map<String, Map<String, Number>>> methodNumberCache = new ConcurrentHashMap<String, Map<String, Map<String, Number>>>();
    private volatile transient Map<String, Map<String, Number>> methodNumbers;
    private final transient Map<String, Map<String, Number>> serviceNumberCache = new ConcurrentHashMap<String, Map<String, Number>>();
    private volatile transient Map<String, Number> numbers;

    public OverrideInstanceAddressURL(InstanceAddressURL originUrl) {
        this.originUrl = originUrl;
        this.overrideParams = new HashMap<String, String>();
    }

    public OverrideInstanceAddressURL(InstanceAddressURL originUrl, Map<String, String> overrideParams) {
        this.originUrl = originUrl;
        this.overrideParams = overrideParams;
    }

    @Override
    public ServiceInstance getInstance() {
        return this.originUrl.getInstance();
    }

    @Override
    public MetadataInfo getMetadataInfo() {
        return this.originUrl.getMetadataInfo();
    }

    @Override
    public String getServiceInterface() {
        return this.originUrl.getServiceInterface();
    }

    @Override
    public String getGroup() {
        return this.originUrl.getGroup();
    }

    @Override
    public String getVersion() {
        return this.originUrl.getVersion();
    }

    @Override
    public String getProtocol() {
        return this.originUrl.getProtocol();
    }

    @Override
    public String getProtocolServiceKey() {
        return this.originUrl.getProtocolServiceKey();
    }

    @Override
    public String getServiceKey() {
        return this.originUrl.getServiceKey();
    }

    @Override
    public String getAddress() {
        return this.originUrl.getAddress();
    }

    public String getHost() {
        return this.originUrl.getHost();
    }

    public int getPort() {
        return this.originUrl.getPort();
    }

    public String getIp() {
        return this.originUrl.getIp();
    }

    @Override
    public String getPath() {
        return this.originUrl.getPath();
    }

    @Override
    public String getParameter(String key) {
        String overrideParam = this.overrideParams.get(key);
        return StringUtils.isNotEmpty((String)overrideParam) ? overrideParam : this.originUrl.getParameter(key);
    }

    @Override
    public String getServiceParameter(String service, String key) {
        String overrideParam = this.overrideParams.get(key);
        return StringUtils.isNotEmpty((String)overrideParam) ? overrideParam : this.originUrl.getServiceParameter(service, key);
    }

    @Override
    public String getServiceMethodParameter(String protocolServiceKey, String method, String key) {
        String overrideParam = this.overrideParams.get(method + "." + key);
        return StringUtils.isNotEmpty((String)overrideParam) ? overrideParam : this.originUrl.getServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public String getMethodParameter(String method, String key) {
        String overrideParam = this.overrideParams.get(method + "." + key);
        return StringUtils.isNotEmpty((String)overrideParam) ? overrideParam : this.originUrl.getMethodParameter(method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method, String key) {
        return StringUtils.isNotEmpty((String)this.overrideParams.get(method + "." + key)) || this.originUrl.hasServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public boolean hasMethodParameter(String method, String key) {
        return StringUtils.isNotEmpty((String)this.overrideParams.get(method + "." + key)) || this.originUrl.hasMethodParameter(method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method) {
        return this.overrideParams.keySet().stream().anyMatch(e -> e.startsWith(method) || this.originUrl.hasServiceMethodParameter(protocolServiceKey, method));
    }

    @Override
    public boolean hasMethodParameter(String method) {
        return this.overrideParams.keySet().stream().anyMatch(e -> e.startsWith(method) || this.originUrl.hasMethodParameter(method));
    }

    @Override
    public Map<String, String> getServiceParameters(String protocolServiceKey) {
        Map<String, String> parameters = this.originUrl.getServiceParameters(protocolServiceKey);
        Map<String, String> overrideParameters = this.overrideParams;
        HashMap<String, String> result = new HashMap<String, String>((int)((float)parameters.size() + (float)overrideParameters.size() / 0.75f) + 1);
        result.putAll(parameters);
        result.putAll(overrideParameters);
        return result;
    }

    @Override
    public Map<String, String> getParameters() {
        Map<String, String> parameters = this.originUrl.getParameters();
        Map<String, String> overrideParameters = this.overrideParams;
        HashMap<String, String> result = new HashMap<String, String>((int)((float)parameters.size() + (float)overrideParameters.size() / 0.75f) + 1);
        result.putAll(parameters);
        result.putAll(overrideParameters);
        return result;
    }

    @Override
    public URL addParameter(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>(this.overrideParams);
        map.put(key, value);
        return new OverrideInstanceAddressURL(this.originUrl, map);
    }

    @Override
    public URL addParameterIfAbsent(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>(this.overrideParams);
        map.putIfAbsent(key, value);
        return new OverrideInstanceAddressURL(this.originUrl, map);
    }

    @Override
    public URL addServiceParameter(String protocolServiceKey, String key, String value) {
        return this.originUrl.addServiceParameter(protocolServiceKey, key, value);
    }

    @Override
    public URL addServiceParameterIfAbsent(String protocolServiceKey, String key, String value) {
        return this.originUrl.addServiceParameterIfAbsent(protocolServiceKey, key, value);
    }

    @Override
    public URL addConsumerParams(String protocolServiceKey, Map<String, String> params) {
        return this.originUrl.addConsumerParams(protocolServiceKey, params);
    }

    public URL addParameters(Map<String, String> parameters) {
        HashMap<String, String> map = new HashMap<String, String>(this.overrideParams);
        map.putAll(parameters);
        return new OverrideInstanceAddressURL(this.originUrl, map);
    }

    public URL addParametersIfAbsent(Map<String, String> parameters) {
        HashMap<String, String> map = new HashMap<String, String>(this.overrideParams);
        parameters.forEach(map::putIfAbsent);
        return new OverrideInstanceAddressURL(this.originUrl, map);
    }

    @Override
    protected Map<String, Number> getServiceNumbers(String protocolServiceKey) {
        return this.serviceNumberCache.computeIfAbsent(protocolServiceKey, k -> new ConcurrentHashMap());
    }

    @Override
    protected Map<String, Number> getNumbers() {
        if (this.numbers == null) {
            this.numbers = new ConcurrentHashMap<String, Number>();
        }
        return this.numbers;
    }

    @Override
    protected Map<String, Map<String, Number>> getServiceMethodNumbers(String protocolServiceKey) {
        return this.methodNumberCache.computeIfAbsent(protocolServiceKey, k -> new ConcurrentHashMap());
    }

    @Override
    protected Map<String, Map<String, Number>> getMethodNumbers() {
        if (this.methodNumbers == null) {
            this.methodNumbers = new ConcurrentHashMap<String, Map<String, Number>>();
        }
        return this.methodNumbers;
    }

    public Map<String, String> getOverrideParams() {
        return this.overrideParams;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OverrideInstanceAddressURL that = (OverrideInstanceAddressURL)((Object)o);
        return Objects.equals(this.overrideParams, that.overrideParams) && Objects.equals((Object)this.originUrl, (Object)that.originUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.overrideParams, this.originUrl});
    }

    @Override
    public String toString() {
        return this.originUrl.toString() + ", overrideParams: " + this.overrideParams.toString();
    }
}

