/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.retry;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.timer.Timeout;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.retry.AbstractRetryTask;
import org.apache.dubbo.registry.support.FailbackRegistry;

public final class FailedNotifiedTask
extends AbstractRetryTask {
    private static final String NAME = "retry notify";
    private final NotifyListener listener;
    private final List<URL> urls = new CopyOnWriteArrayList<URL>();

    public FailedNotifiedTask(URL url, NotifyListener listener) {
        super(url, null, NAME);
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listener = listener;
    }

    public void addUrlToRetry(List<URL> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return;
        }
        this.urls.addAll(urls);
    }

    public void removeRetryUrl(List<URL> urls) {
        this.urls.removeAll(urls);
    }

    @Override
    protected void doRetry(URL url, FailbackRegistry registry, Timeout timeout) {
        if (CollectionUtils.isNotEmpty(this.urls)) {
            this.listener.notify(this.urls);
            this.urls.clear();
        }
        this.reput(timeout, this.retryPeriod);
    }
}

