/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.integration.InterfaceCompatibleRegistryProtocol;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.directory.AbstractDirectory;

public abstract class DynamicDirectory<T>
extends AbstractDirectory<T>
implements NotifyListener {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDirectory.class);
    protected static final Cluster CLUSTER = (Cluster)ExtensionLoader.getExtensionLoader(Cluster.class).getAdaptiveExtension();
    protected static final RouterFactory ROUTER_FACTORY = (RouterFactory)ExtensionLoader.getExtensionLoader(RouterFactory.class).getAdaptiveExtension();
    protected final String serviceKey;
    protected final Class<T> serviceType;
    protected final boolean multiGroup;
    protected Protocol protocol;
    protected Registry registry;
    protected volatile boolean forbidden = false;
    protected boolean shouldRegister;
    protected boolean shouldSimplified;
    protected volatile URL overrideConsumerUrl;
    protected volatile URL registeredConsumerUrl;
    protected volatile List<Configurator> configurators;
    protected volatile Map<URL, Invoker<T>> urlInvokerMap;
    protected volatile List<Invoker<T>> invokers;
    protected volatile Set<URL> cachedInvokerUrls;
    protected ServiceInstancesChangedListener serviceListener;

    public DynamicDirectory(Class<T> serviceType, URL url) {
        super(url);
        if (serviceType == null) {
            throw new IllegalArgumentException("service type is null.");
        }
        this.shouldRegister = !"*".equals(url.getServiceInterface()) && url.getParameter("register", true);
        this.shouldSimplified = url.getParameter("simplified", false);
        if (url.getServiceKey() == null || url.getServiceKey().length() == 0) {
            throw new IllegalArgumentException("registry serviceKey is null.");
        }
        this.serviceType = serviceType;
        this.serviceKey = super.getConsumerUrl().getServiceKey();
        String group = this.queryMap.get("group") != null ? (String)this.queryMap.get("group") : "";
        this.multiGroup = group != null && ("*".equals(group) || group.contains(","));
    }

    @Override
    public void addServiceListener(ServiceInstancesChangedListener instanceListener) {
        this.serviceListener = instanceListener;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public boolean isShouldRegister() {
        return this.shouldRegister;
    }

    public void subscribe(URL url) {
        this.setConsumerUrl(url);
        this.registry.subscribe(url, this);
    }

    public void unSubscribe(URL url) {
        this.setConsumerUrl(null);
        this.registry.unsubscribe(url, this);
    }

    public List<Invoker<T>> doList(Invocation invocation) {
        if (this.forbidden) {
            throw new RpcException(4, "No provider available from registry " + this.getUrl().getAddress() + " for service " + this.getConsumerUrl().getServiceKey() + " on consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please check status of providers(disabled, not registered or in blacklist).");
        }
        if (this.multiGroup) {
            return this.invokers == null ? Collections.emptyList() : this.invokers;
        }
        List invokers = null;
        try {
            invokers = this.routerChain.route(this.getConsumerUrl(), invocation);
        }
        catch (Throwable t) {
            logger.error("Failed to execute router: " + this.getUrl() + ", cause: " + t.getMessage(), t);
        }
        return invokers == null ? Collections.emptyList() : invokers;
    }

    public Class<T> getInterface() {
        return this.serviceType;
    }

    public List<Invoker<T>> getAllInvokers() {
        return this.invokers;
    }

    public URL getRegisteredConsumerUrl() {
        return this.registeredConsumerUrl;
    }

    public void setRegisteredConsumerUrl(URL url) {
        this.registeredConsumerUrl = !this.shouldSimplified ? url.addParameters(new String[]{"category", "consumers", "check", String.valueOf(false)}) : URL.valueOf((URL)url, (String[])InterfaceCompatibleRegistryProtocol.DEFAULT_REGISTER_CONSUMER_KEYS, null).addParameters(new String[]{"category", "consumers", "check", String.valueOf(false)});
    }

    public boolean isAvailable() {
        if (this.isDestroyed()) {
            return false;
        }
        Map<URL, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null && localUrlInvokerMap.size() > 0) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                if (!invoker.isAvailable()) continue;
                return true;
            }
        }
        return false;
    }

    public void buildRouterChain(URL url) {
        this.setRouterChain(RouterChain.buildChain((URL)url));
    }

    public Map<URL, Invoker<T>> getUrlInvokerMap() {
        return this.urlInvokerMap;
    }

    public List<Invoker<T>> getInvokers() {
        return this.invokers;
    }

    public void setConsumerUrl(URL consumerUrl) {
        this.consumerUrl = consumerUrl;
        this.overrideConsumerUrl = consumerUrl;
    }
}

