/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.MetaCacheManager;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractServiceDiscovery
implements ServiceDiscovery {
    private final Logger logger = LoggerFactory.getLogger(AbstractServiceDiscovery.class);
    private volatile boolean isDestroy;
    protected final String serviceName;
    protected volatile ServiceInstance serviceInstance;
    protected volatile MetadataInfo metadataInfo;
    protected MetadataReport metadataReport;
    protected String metadataType;
    protected final MetaCacheManager metaCacheManager;
    protected URL registryURL;
    protected Set<ServiceInstancesChangedListener> instanceListeners = new ConcurrentHashSet();
    protected ApplicationModel applicationModel = ApplicationModel.defaultModel();

    public AbstractServiceDiscovery(ApplicationModel applicationModel, URL registryURL) {
        this(applicationModel.getApplicationName(), registryURL);
        this.applicationModel = applicationModel;
        MetadataReportInstance metadataReportInstance = (MetadataReportInstance)applicationModel.getBeanFactory().getBean(MetadataReportInstance.class);
        this.metadataType = metadataReportInstance.getMetadataType();
        this.metadataReport = metadataReportInstance.getMetadataReport(registryURL.getParameter("REGISTRY_CLUSTER"));
    }

    public AbstractServiceDiscovery(String serviceName, URL registryURL) {
        this.registryURL = registryURL;
        this.serviceName = serviceName;
        this.metadataInfo = new MetadataInfo(serviceName);
        boolean localCacheEnabled = registryURL.getParameter("file.cache", true);
        this.metaCacheManager = new MetaCacheManager(localCacheEnabled, this.getCacheNameSuffix(), ((FrameworkExecutorRepository)this.applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getCacheRefreshingScheduledExecutor());
    }

    @Override
    public synchronized void register() throws RuntimeException {
        this.serviceInstance = this.createServiceInstance(this.metadataInfo);
        if (!ServiceInstanceMetadataUtils.isValidInstance(this.serviceInstance)) {
            this.logger.warn("No valid instance found, stop registering instance address to registry.");
            return;
        }
        boolean revisionUpdated = this.calOrUpdateInstanceRevision(this.serviceInstance);
        if (revisionUpdated) {
            this.reportMetadata(this.metadataInfo);
            this.doRegister(this.serviceInstance);
        }
    }

    @Override
    public synchronized void update() throws RuntimeException {
        if (this.isDestroy) {
            return;
        }
        if (this.serviceInstance == null) {
            this.serviceInstance = this.createServiceInstance(this.metadataInfo);
        } else if (!ServiceInstanceMetadataUtils.isValidInstance(this.serviceInstance)) {
            ServiceInstanceMetadataUtils.customizeInstance(this.serviceInstance, this.applicationModel);
        }
        if (!ServiceInstanceMetadataUtils.isValidInstance(this.serviceInstance)) {
            return;
        }
        boolean revisionUpdated = this.calOrUpdateInstanceRevision(this.serviceInstance);
        if (revisionUpdated) {
            this.logger.info(String.format("Metadata of instance changed, updating instance with revision %s.", this.serviceInstance.getServiceMetadata().getRevision()));
            this.doUpdate(this.serviceInstance);
        }
    }

    @Override
    public synchronized void unregister() throws RuntimeException {
        if (!ServiceInstanceMetadataUtils.isValidInstance(this.serviceInstance)) {
            return;
        }
        this.doUnregister(this.serviceInstance);
    }

    @Override
    public final ServiceInstance getLocalInstance() {
        return this.serviceInstance;
    }

    @Override
    public MetadataInfo getLocalMetadata() {
        return this.metadataInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataInfo getRemoteMetadata(String revision, List<ServiceInstance> instances) {
        MetadataInfo metadata = (MetadataInfo)this.metaCacheManager.get(revision);
        if (metadata != null && metadata != MetadataInfo.EMPTY) {
            metadata.init();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("MetadataInfo for revision=" + revision + ", " + metadata);
            }
            return metadata;
        }
        MetaCacheManager metaCacheManager = this.metaCacheManager;
        synchronized (metaCacheManager) {
            int triedTimes = 0;
            while (triedTimes < 3) {
                metadata = MetadataUtils.getRemoteMetadata(revision, instances, this.metadataReport);
                if (metadata != MetadataInfo.EMPTY) {
                    metadata.init();
                    break;
                }
                if (triedTimes > 0 && this.logger.isDebugEnabled()) {
                    this.logger.debug("Retry the " + triedTimes + " times to get metadata for revision=" + revision);
                }
                ++triedTimes;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (metadata == MetadataInfo.EMPTY) {
                this.logger.error("Failed to get metadata for revision after 3 retries, revision=" + revision);
            } else {
                this.metaCacheManager.put(revision, metadata);
            }
        }
        return metadata;
    }

    @Override
    public MetadataInfo getRemoteMetadata(String revision) {
        return (MetadataInfo)this.metaCacheManager.get(revision);
    }

    @Override
    public final void destroy() throws Exception {
        this.isDestroy = true;
        this.metaCacheManager.destroy();
        this.doDestroy();
    }

    @Override
    public final boolean isDestroy() {
        return this.isDestroy;
    }

    @Override
    public void register(URL url) {
        this.metadataInfo.addService(url);
    }

    @Override
    public void unregister(URL url) {
        this.metadataInfo.removeService(url);
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        this.metadataInfo.addSubscribedURL(url);
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        this.metadataInfo.removeSubscribedURL(url);
    }

    @Override
    public List<URL> lookup(URL url) {
        throw new UnsupportedOperationException("Service discovery implementation does not support lookup of url list.");
    }

    protected void doUpdate(ServiceInstance serviceInstance) throws RuntimeException {
        this.unregister();
        if (!"0".equals(ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance))) {
            this.reportMetadata(serviceInstance.getServiceMetadata());
            this.doRegister(serviceInstance);
        }
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    protected abstract void doRegister(ServiceInstance var1) throws RuntimeException;

    protected abstract void doUnregister(ServiceInstance var1);

    protected abstract void doDestroy() throws Exception;

    protected ServiceInstance createServiceInstance(MetadataInfo metadataInfo) {
        DefaultServiceInstance instance = new DefaultServiceInstance(this.serviceName, this.applicationModel);
        instance.setServiceMetadata(metadataInfo);
        ServiceInstanceMetadataUtils.setMetadataStorageType(instance, this.metadataType);
        ServiceInstanceMetadataUtils.customizeInstance(instance, this.applicationModel);
        return instance;
    }

    protected boolean calOrUpdateInstanceRevision(ServiceInstance instance) {
        String existingInstanceRevision = ServiceInstanceMetadataUtils.getExportedServicesRevision(instance);
        MetadataInfo metadataInfo = instance.getServiceMetadata();
        String newRevision = metadataInfo.calAndGetRevision();
        if (!newRevision.equals(existingInstanceRevision)) {
            instance.getMetadata().put("dubbo.metadata.revision", metadataInfo.getRevision());
            return true;
        }
        return false;
    }

    protected void reportMetadata(MetadataInfo metadataInfo) {
        if (this.metadataReport != null) {
            SubscriberMetadataIdentifier identifier = new SubscriberMetadataIdentifier(this.serviceName, metadataInfo.getRevision());
            if ("local".equals(this.metadataType) && this.metadataReport.shouldReportMetadata() || "remote".equals(this.metadataType)) {
                this.metadataReport.publishAppMetadata(identifier, metadataInfo);
            }
        }
    }

    protected void unReportMetadata(MetadataInfo metadataInfo) {
        if (this.metadataReport != null) {
            SubscriberMetadataIdentifier identifier = new SubscriberMetadataIdentifier(this.serviceName, metadataInfo.getRevision());
            if ("local".equals(this.metadataType) && this.metadataReport.shouldReportMetadata() || "remote".equals(this.metadataType)) {
                this.metadataReport.unPublishAppMetadata(identifier, metadataInfo);
            }
        }
    }

    private String getCacheNameSuffix() {
        String name = this.getClass().getSimpleName();
        int i = name.indexOf(ServiceDiscovery.class.getSimpleName());
        if (i != -1) {
            name = name.substring(0, i);
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        Optional application = this.applicationModel.getApplicationConfigManager().getApplication();
        if (application.isPresent()) {
            stringBuilder.append(((ApplicationConfig)application.get()).getName());
            stringBuilder.append(".");
        }
        stringBuilder.append(name.toLowerCase());
        URL url = this.getUrl();
        if (url != null) {
            stringBuilder.append(".");
            stringBuilder.append(url.getBackupAddress());
        }
        return stringBuilder.toString();
    }
}

