/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.AbstractServiceNameMapping;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.NopServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class ServiceDiscoveryRegistry
extends FailbackRegistry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceDiscovery serviceDiscovery;
    private final AbstractServiceNameMapping serviceNameMapping;
    private final Map<String, ServiceInstancesChangedListener> serviceListeners = new ConcurrentHashMap<String, ServiceInstancesChangedListener>();
    private final Map<String, MappingListener> mappingListeners = new ConcurrentHashMap<String, MappingListener>();
    private final ConcurrentMap<String, Lock> appSubscriptionLocks = new ConcurrentHashMap<String, Lock>();

    public ServiceDiscoveryRegistry(URL registryURL, ApplicationModel applicationModel) {
        super(registryURL);
        this.serviceDiscovery = this.createServiceDiscovery(registryURL);
        this.serviceNameMapping = (AbstractServiceNameMapping)ServiceNameMapping.getDefaultExtension((ScopeModel)registryURL.getScopeModel());
        this.applicationModel = applicationModel;
    }

    protected ServiceDiscoveryRegistry(URL registryURL, ServiceDiscovery serviceDiscovery, ServiceNameMapping serviceNameMapping) {
        super(registryURL);
        this.serviceDiscovery = serviceDiscovery;
        this.serviceNameMapping = (AbstractServiceNameMapping)serviceNameMapping;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    protected ServiceDiscovery createServiceDiscovery(URL registryURL) {
        return this.getServiceDiscovery(registryURL.addParameter("interface", ServiceDiscovery.class.getName()).removeParameter("registry-type"));
    }

    private ServiceDiscovery getServiceDiscovery(URL registryURL) {
        ServiceDiscoveryFactory factory = ServiceDiscoveryFactory.getExtension(registryURL);
        return factory.getServiceDiscovery(registryURL);
    }

    protected boolean shouldRegister(URL providerURL) {
        String side = providerURL.getSide();
        boolean should = "provider".equals(side);
        if (!should && this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("The URL[%s] should not be registered.", providerURL));
        }
        if (!this.acceptable(providerURL)) {
            this.logger.info("URL " + providerURL + " will not be registered to Registry. Registry " + this.getUrl() + " does not accept service of this protocol type.");
            return false;
        }
        return should;
    }

    protected boolean shouldSubscribe(URL subscribedURL) {
        return !this.shouldRegister(subscribedURL);
    }

    @Override
    public final void register(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doRegister(url);
    }

    @Override
    public void doRegister(URL url) {
        url = this.addRegistryClusterKey(url);
        this.serviceDiscovery.register(url);
    }

    @Override
    public final void unregister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doUnregister(url);
    }

    @Override
    public void doUnregister(URL url) {
        url = this.addRegistryClusterKey(url);
        this.serviceDiscovery.unregister(url);
    }

    @Override
    public final void subscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        this.doSubscribe(url, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        url = this.addRegistryClusterKey(url);
        this.serviceDiscovery.subscribe(url, listener);
        boolean check = url.getParameter("check", false);
        String key = ServiceNameMapping.buildMappingKey((URL)url);
        Lock mappingLock = this.serviceNameMapping.getMappingLock(key);
        try {
            mappingLock.lock();
            Set subscribedServices = this.serviceNameMapping.getCachedMapping(url);
            try {
                DefaultMappingListener mappingListener = new DefaultMappingListener(url, subscribedServices, listener);
                subscribedServices = this.serviceNameMapping.getAndListen(this.getUrl(), url, (MappingListener)mappingListener);
                this.mappingListeners.put(url.getProtocolServiceKey(), mappingListener);
            }
            catch (Exception e) {
                this.logger.warn("Cannot find app mapping for service " + url.getServiceInterface() + ", will not migrate.", (Throwable)e);
            }
            if (CollectionUtils.isEmpty((Collection)subscribedServices)) {
                this.logger.info("No interface-apps mapping found in local cache, stop subscribing, will automatically wait for mapping listener callback: " + url);
                return;
            }
            this.subscribeURLs(url, listener, subscribedServices);
        }
        finally {
            mappingLock.unlock();
        }
    }

    @Override
    public final void unsubscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        url = this.addRegistryClusterKey(url);
        this.doUnsubscribe(url, listener);
    }

    private URL addRegistryClusterKey(URL url) {
        String registryCluster = this.serviceDiscovery.getUrl().getParameter("REGISTRY_CLUSTER");
        if (registryCluster != null && url.getParameter("REGISTRY_CLUSTER") == null) {
            url = url.addParameter("REGISTRY_CLUSTER", registryCluster);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        this.serviceDiscovery.unsubscribe(url, listener);
        String protocolServiceKey = url.getProtocolServiceKey();
        Set serviceNames = this.serviceNameMapping.getCachedMapping(url);
        this.serviceNameMapping.stopListen(url, this.mappingListeners.remove(protocolServiceKey));
        if (CollectionUtils.isNotEmpty((Collection)serviceNames)) {
            String serviceNamesKey = ServiceNameMapping.toStringKeys((Set)serviceNames);
            Lock appSubscriptionLock = this.getAppSubscription(serviceNamesKey);
            try {
                appSubscriptionLock.lock();
                ServiceInstancesChangedListener instancesChangedListener = this.serviceListeners.get(serviceNamesKey);
                if (instancesChangedListener != null) {
                    instancesChangedListener.removeListener(protocolServiceKey, listener);
                    if (!instancesChangedListener.hasListeners()) {
                        instancesChangedListener.destroy();
                        this.serviceListeners.remove(serviceNamesKey);
                        this.removeAppSubscriptionLock(serviceNamesKey);
                    }
                }
            }
            finally {
                appSubscriptionLock.unlock();
            }
        }
    }

    @Override
    public List<URL> lookup(URL url) {
        throw new UnsupportedOperationException("");
    }

    public boolean isAvailable() {
        if (this.serviceDiscovery instanceof NopServiceDiscovery) {
            return true;
        }
        return !this.serviceDiscovery.isDestroy() && !this.serviceDiscovery.getServices().isEmpty();
    }

    @Override
    public void destroy() {
        this.registryManager.removeDestroyedRegistry(this);
        ThrowableAction.execute(this.serviceDiscovery::destroy);
        for (ServiceInstancesChangedListener listener : this.serviceListeners.values()) {
            listener.destroy();
        }
        this.appSubscriptionLocks.clear();
        this.serviceListeners.clear();
        this.mappingListeners.clear();
    }

    @Override
    public boolean isServiceDiscovery() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribeURLs(URL url, NotifyListener listener, Set<String> serviceNames) {
        serviceNames = CollectionUtils.toTreeSet(serviceNames);
        String serviceNamesKey = ServiceNameMapping.toStringKeys((Set)serviceNames);
        String protocolServiceKey = url.getProtocolServiceKey();
        this.logger.info(String.format("Trying to subscribe from apps %s for service key %s, ", serviceNamesKey, protocolServiceKey));
        Lock appSubscriptionLock = this.getAppSubscription(serviceNamesKey);
        try {
            appSubscriptionLock.lock();
            ServiceInstancesChangedListener serviceInstancesChangedListener = this.serviceListeners.get(serviceNamesKey);
            if (serviceInstancesChangedListener == null) {
                serviceInstancesChangedListener = this.serviceDiscovery.createListener(serviceNames);
                serviceInstancesChangedListener.setUrl(url);
                for (String serviceName : serviceNames) {
                    List<ServiceInstance> serviceInstances = this.serviceDiscovery.getInstances(serviceName);
                    if (!CollectionUtils.isNotEmpty(serviceInstances)) continue;
                    serviceInstancesChangedListener.onEvent(new ServiceInstancesChangedEvent(serviceName, serviceInstances));
                }
                this.serviceListeners.put(serviceNamesKey, serviceInstancesChangedListener);
            }
            if (!serviceInstancesChangedListener.isDestroyed()) {
                serviceInstancesChangedListener.setUrl(url);
                listener.addServiceListener(serviceInstancesChangedListener);
                serviceInstancesChangedListener.addListenerAndNotify(protocolServiceKey, listener);
                this.serviceDiscovery.addServiceInstancesChangedListener(serviceInstancesChangedListener);
            } else {
                this.logger.info(String.format("Listener of %s has been destroyed by another thread.", serviceNamesKey));
                this.serviceListeners.remove(serviceNamesKey);
            }
        }
        finally {
            appSubscriptionLock.unlock();
        }
    }

    public static boolean supports(URL registryURL) {
        return "service".equalsIgnoreCase(registryURL.getParameter("registry-type"));
    }

    public Map<String, ServiceInstancesChangedListener> getServiceListeners() {
        return this.serviceListeners;
    }

    public Lock getAppSubscription(String key) {
        return this.appSubscriptionLocks.computeIfAbsent(key, _k -> new ReentrantLock());
    }

    public void removeAppSubscriptionLock(String key) {
        Lock lock = (Lock)this.appSubscriptionLocks.get(key);
        if (lock != null) {
            try {
                lock.lock();
                this.appSubscriptionLocks.remove(key);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private class DefaultMappingListener
    implements MappingListener {
        private final Logger logger = LoggerFactory.getLogger(DefaultMappingListener.class);
        private final URL url;
        private Set<String> oldApps;
        private NotifyListener listener;
        private volatile boolean stopped;

        public DefaultMappingListener(URL subscribedURL, Set<String> serviceNames, NotifyListener listener) {
            this.url = subscribedURL;
            this.oldApps = serviceNames;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onEvent(MappingChangedEvent event) {
            this.logger.info("Received mapping notification from meta server, " + event);
            if (this.stopped) {
                this.logger.warn("Listener has been stopped, ignore mapping notification, check why listener is not removed.");
                return;
            }
            Set newApps = event.getApps();
            Set<String> tempOldApps = this.oldApps;
            if (CollectionUtils.isEmpty((Collection)newApps) || CollectionUtils.equals((Collection)newApps, tempOldApps)) {
                return;
            }
            this.logger.info("Mapping of service " + event.getServiceKey() + "changed from " + tempOldApps + " to " + newApps);
            Lock mappingLock = ServiceDiscoveryRegistry.this.serviceNameMapping.getMappingLock(event.getServiceKey());
            try {
                mappingLock.lock();
                if (CollectionUtils.isEmpty(tempOldApps) && newApps.size() > 0) {
                    ServiceDiscoveryRegistry.this.serviceNameMapping.putCachedMapping(ServiceNameMapping.buildMappingKey((URL)this.url), newApps);
                    ServiceDiscoveryRegistry.this.subscribeURLs(this.url, this.listener, newApps);
                    this.oldApps = newApps;
                    return;
                }
                for (String newAppName : newApps) {
                    if (tempOldApps.contains(newAppName)) continue;
                    ServiceDiscoveryRegistry.this.serviceNameMapping.removeCachedMapping(ServiceNameMapping.buildMappingKey((URL)this.url));
                    ServiceDiscoveryRegistry.this.serviceNameMapping.putCachedMapping(ServiceNameMapping.buildMappingKey((URL)this.url), newApps);
                    ServiceInstancesChangedListener oldListener = this.listener.getServiceListener();
                    if (oldListener != null) {
                        String appKey = ServiceNameMapping.toStringKeys((Set)CollectionUtils.toTreeSet(tempOldApps));
                        Lock appSubscriptionLock = ServiceDiscoveryRegistry.this.getAppSubscription(appKey);
                        try {
                            appSubscriptionLock.lock();
                            oldListener.removeListener(this.url.getProtocolServiceKey(), this.listener);
                            if (!oldListener.hasListeners()) {
                                oldListener.destroy();
                                ServiceDiscoveryRegistry.this.removeAppSubscriptionLock(appKey);
                            }
                        }
                        finally {
                            appSubscriptionLock.unlock();
                        }
                    }
                    ServiceDiscoveryRegistry.this.subscribeURLs(this.url, this.listener, newApps);
                    this.oldApps = newApps;
                    return;
                }
            }
            finally {
                mappingLock.unlock();
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }
}

