/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.InstanceMetadataChangedListener;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.RevisionResolver;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class SelfHostMetaServiceDiscovery
implements ServiceDiscovery {
    private volatile boolean isDestroy;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private URL registryURL;
    private final ScheduledExecutorService echoCheckExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Dubbo-Registry-EchoCheck-Consumer"));
    private ServiceInstance serviceInstance;
    private String lastMetadataRevision;
    private final ConcurrentHashMap<String, String> metadataMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ServiceInstance>> cachedServiceInstances = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> serviceInstanceRevisionMap = new ConcurrentHashMap();

    @Override
    public void initialize(URL registryURL) throws Exception {
        this.registryURL = registryURL;
        this.doInitialize(registryURL);
        long echoPollingCycle = registryURL.getParameter("echoPollingCycle", 60000);
        this.echoCheckExecutor.scheduleAtFixedRate(() -> {
            WritableMetadataService metadataService = WritableMetadataService.getDefaultExtension();
            Map listenerMap = metadataService.getInstanceMetadataChangedListenerMap();
            Iterator iterator = listenerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                try {
                    ((InstanceMetadataChangedListener)entry.getValue()).echo("dubbo");
                }
                catch (RpcException e) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Send echo message to consumer error. Possible cause: consumer is offline.");
                    }
                    iterator.remove();
                }
            }
        }, echoPollingCycle, echoPollingCycle, TimeUnit.MILLISECONDS);
    }

    @Override
    public void destroy() throws Exception {
        this.isDestroy = true;
        this.doDestroy();
        this.metadataMap.clear();
        this.serviceInstanceRevisionMap.clear();
        this.echoCheckExecutor.shutdown();
    }

    @Override
    public boolean isDestroy() {
        return this.isDestroy;
    }

    private void updateMetadata(ServiceInstance serviceInstance) {
        WritableMetadataService metadataService = WritableMetadataService.getDefaultExtension();
        String metadataString = JSONObject.toJSONString(serviceInstance.getMetadata());
        String metadataRevision = RevisionResolver.calRevision((String)metadataString);
        if (!metadataRevision.equalsIgnoreCase(this.lastMetadataRevision)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Update Service Instance Metadata of DNS registry. Newer metadata: " + metadataString);
            }
            this.lastMetadataRevision = metadataRevision;
            metadataService.exportInstanceMetadata(metadataString);
            Map listenerMap = metadataService.getInstanceMetadataChangedListenerMap();
            Iterator iterator = listenerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                try {
                    ((InstanceMetadataChangedListener)entry.getValue()).onEvent(metadataString);
                }
                catch (RpcException e) {
                    this.logger.warn("Notify to consumer error. Possible cause: consumer is offline.");
                    iterator.remove();
                }
            }
        }
    }

    @Override
    public void register(ServiceInstance serviceInstance) throws RuntimeException {
        this.serviceInstance = serviceInstance;
        this.updateMetadata(serviceInstance);
        this.doRegister(serviceInstance);
    }

    @Override
    public void update(ServiceInstance serviceInstance) throws RuntimeException {
        this.serviceInstance = serviceInstance;
        this.updateMetadata(serviceInstance);
        this.doUpdate(serviceInstance);
    }

    @Override
    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        this.doUnregister(serviceInstance);
        this.serviceInstance = null;
        WritableMetadataService metadataService = WritableMetadataService.getDefaultExtension();
        metadataService.exportInstanceMetadata("");
        metadataService.getInstanceMetadataChangedListenerMap().forEach((consumerId, listener) -> listener.onEvent(""));
        metadataService.getInstanceMetadataChangedListenerMap().clear();
    }

    @Override
    public ServiceInstance getLocalInstance() {
        return this.serviceInstance;
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    public final void fillServiceInstance(DefaultServiceInstance serviceInstance) {
        String hostId = serviceInstance.getAddress();
        if (this.metadataMap.containsKey(hostId)) {
            String metadataString2 = this.metadataMap.get(hostId);
            serviceInstance.setMetadata((Map)JSONObject.parseObject((String)metadataString2, Map.class));
        } else {
            MetadataService metadataService = MetadataUtils.getMetadataServiceProxy(serviceInstance);
            String consumerId = ApplicationModel.getName() + NetUtils.getLocalHost();
            String metadata = metadataService.getAndListenInstanceMetadata(consumerId, metadataString -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Receive callback: " + metadataString + serviceInstance);
                }
                if (StringUtils.isEmpty((String)metadataString)) {
                    this.metadataMap.remove(hostId);
                } else {
                    this.metadataMap.put(hostId, metadataString);
                }
            });
            this.metadataMap.put(hostId, metadata);
            serviceInstance.setMetadata((Map)JSONObject.parseObject((String)metadata, Map.class));
        }
    }

    public final void notifyListener(String serviceName, ServiceInstancesChangedListener listener, List<ServiceInstance> instances) {
        boolean changed;
        String serviceInstanceRevision = RevisionResolver.calRevision((String)JSONObject.toJSONString(instances));
        boolean bl = changed = !serviceInstanceRevision.equalsIgnoreCase(this.serviceInstanceRevisionMap.put(serviceName, serviceInstanceRevision));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Service changed event received (possibly because of DNS polling). Service Instance changed: " + changed + " Service Name: " + serviceName);
        }
        if (changed) {
            List oldServiceInstances = this.cachedServiceInstances.getOrDefault(serviceName, new LinkedList());
            HashSet<ServiceInstance> allServiceInstances = new HashSet<ServiceInstance>(oldServiceInstances.size() + instances.size());
            allServiceInstances.addAll(oldServiceInstances);
            allServiceInstances.addAll(instances);
            allServiceInstances.removeAll(oldServiceInstances);
            allServiceInstances.forEach(removedServiceInstance -> MetadataUtils.destroyMetadataServiceProxy(removedServiceInstance));
            this.cachedServiceInstances.put(serviceName, instances);
            listener.onEvent(new ServiceInstancesChangedEvent(serviceName, instances));
        }
    }

    public void doInitialize(URL registryURL) throws Exception {
    }

    public void doDestroy() throws Exception {
    }

    public void doRegister(ServiceInstance serviceInstance) throws RuntimeException {
    }

    public void doUpdate(ServiceInstance serviceInstance) throws RuntimeException {
    }

    public void doUnregister(ServiceInstance serviceInstance) throws RuntimeException {
    }

    @Deprecated
    public final ConcurrentHashMap<String, List<ServiceInstance>> getCachedServiceInstances() {
        return this.cachedServiceInstances;
    }
}

