/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import org.apache.dubbo.registry.client.InstanceAddressURL;

public interface ServiceInstance
extends Serializable {
    public String getServiceName();

    public String getHost();

    public int getPort();

    public String getAddress();

    default public boolean isEnabled() {
        return true;
    }

    default public boolean isHealthy() {
        return true;
    }

    public Map<String, String> getMetadata();

    public SortedMap<String, String> getSortedMetadata();

    public String getRegistryCluster();

    public void setRegistryCluster(String var1);

    public Map<String, String> getExtendParams();

    public Map<String, String> getAllParams();

    default public String getMetadata(String name) {
        return this.getMetadata(name, null);
    }

    default public String getMetadata(String name, String defaultValue) {
        return this.getMetadata().getOrDefault(name, defaultValue);
    }

    public int hashCode();

    public boolean equals(Object var1);

    public InstanceAddressURL toURL();
}

