/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.AbstractServiceNameMapping;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataServiceNameMapping
extends AbstractServiceNameMapping {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final List<String> IGNORED_SERVICE_INTERFACES = Collections.singletonList(MetadataService.class.getName());
    private static final int CAS_RETRY_TIMES = 6;

    public void map(URL url) {
        this.execute(() -> {
            ConfigItem configItem;
            boolean success;
            if (CollectionUtils.isEmpty((Collection)ApplicationModel.getConfigManager().getMetadataConfigs())) {
                return;
            }
            String serviceInterface = url.getServiceInterface();
            if (IGNORED_SERVICE_INTERFACES.contains(serviceInterface)) {
                return;
            }
            String registryCluster = this.getRegistryCluster(url);
            MetadataReport metadataReport = MetadataReportInstance.getMetadataReport((String)registryCluster);
            if (metadataReport.registerServiceAppMapping(serviceInterface, ApplicationModel.getName(), url)) {
                return;
            }
            int currentRetryTimes = 1;
            String newConfigContent = ApplicationModel.getName();
            do {
                String oldConfigContent;
                if (!StringUtils.isNotEmpty((String)(oldConfigContent = (configItem = metadataReport.getConfigItem(serviceInterface, "mapping")).getContent()))) continue;
                boolean contains = StringUtils.isContains((String)oldConfigContent, (String)ApplicationModel.getName());
                if (contains) break;
                newConfigContent = oldConfigContent + "," + ApplicationModel.getName();
            } while (!(success = metadataReport.registerServiceAppMapping(serviceInterface, "mapping", newConfigContent, configItem.getTicket())) && currentRetryTimes++ <= 6);
        });
    }

    public Set<String> get(URL url) {
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        this.execute(() -> {
            String serviceInterface = url.getServiceInterface();
            String registryCluster = this.getRegistryCluster(url);
            MetadataReport metadataReport = MetadataReportInstance.getMetadataReport((String)registryCluster);
            Set apps = metadataReport.getServiceAppMapping(serviceInterface, url);
            serviceNames.addAll(apps);
        });
        return serviceNames;
    }

    public Set<String> getAndListen(URL url, MappingListener mappingListener) {
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        this.execute(() -> {
            String serviceInterface = url.getServiceInterface();
            String registryCluster = this.getRegistryCluster(url);
            MetadataReport metadataReport = MetadataReportInstance.getMetadataReport((String)registryCluster);
            Set apps = metadataReport.getServiceAppMapping(serviceInterface, mappingListener, url);
            serviceNames.addAll(apps);
        });
        return serviceNames;
    }

    protected String getRegistryCluster(URL url) {
        int i;
        String registryCluster = RegistryClusterIdentifier.getExtension(url).providerKey(url);
        if (registryCluster == null) {
            registryCluster = "default";
        }
        if ((i = registryCluster.indexOf(",")) > 0) {
            registryCluster = registryCluster.substring(0, i);
        }
        return registryCluster;
    }

    private void execute(Runnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn(e.getMessage(), e);
            }
        }
    }
}

