/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;

public class MetadataServiceURLParamsMetadataCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public void customize(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        String propertyName = this.resolveMetadataPropertyName(serviceInstance);
        String propertyValue = this.resolveMetadataPropertyValue(serviceInstance);
        if (!StringUtils.isBlank((CharSequence)propertyName) && !StringUtils.isBlank((CharSequence)propertyValue)) {
            metadata.put(propertyName, propertyValue);
        }
    }

    private String resolveMetadataPropertyName(ServiceInstance serviceInstance) {
        return ServiceInstanceMetadataUtils.METADATA_SERVICE_URL_PARAMS_PROPERTY_NAME;
    }

    private String resolveMetadataPropertyValue(ServiceInstance serviceInstance) {
        WritableMetadataService writableMetadataService = WritableMetadataService.getDefaultExtension();
        return ServiceInstanceMetadataUtils.getMetadataServiceParameter(writableMetadataService.getMetadataServiceURL());
    }
}

