/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.retry;

import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.timer.Timeout;
import org.apache.dubbo.common.timer.Timer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.support.FailbackRegistry;

public abstract class AbstractRetryTask
implements TimerTask {
    protected final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    protected final URL url;
    protected final FailbackRegistry registry;
    private final long retryPeriod;
    private final int retryTimes;
    private final String taskName;
    private int times = 1;
    private volatile boolean cancel;

    AbstractRetryTask(URL url, FailbackRegistry registry, String taskName) {
        if (url == null || StringUtils.isBlank((CharSequence)taskName)) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.registry = registry;
        this.taskName = taskName;
        this.cancel = false;
        this.retryPeriod = url.getParameter("retry.period", 5000);
        this.retryTimes = url.getParameter("retry.times", -1);
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    protected void reput(Timeout timeout, long tick) {
        if (timeout == null) {
            throw new IllegalArgumentException();
        }
        Timer timer = timeout.timer();
        if (timer.isStop() || timeout.isCancelled() || this.isCancel()) {
            return;
        }
        ++this.times;
        timer.newTimeout(timeout.task(), tick, TimeUnit.MILLISECONDS);
    }

    public void run(Timeout timeout) throws Exception {
        if (timeout.isCancelled() || timeout.timer().isStop() || this.isCancel()) {
            return;
        }
        if (this.retryTimes > 0 && this.times > this.retryTimes) {
            this.logger.warn("1-13", "registry center offline", "Check the registry server.", "Final failed to execute task " + this.taskName + ", url: " + this.url + ", retry " + this.retryTimes + " times.");
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.taskName + " : " + this.url);
        }
        try {
            this.doRetry(this.url, this.registry, timeout);
        }
        catch (Throwable t) {
            this.logger.warn("1-13", "registry center offline", "Check the registry server.", "Failed to execute task " + this.taskName + ", url: " + this.url + ", waiting for again, cause:" + t.getMessage(), t);
            this.reput(timeout, this.retryPeriod);
        }
    }

    protected abstract void doRetry(URL var1, FailbackRegistry var2, Timeout var3);
}

