/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Client;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.Transporter;
import org.apache.dubbo.remoting.transport.ChannelHandlerAdapter;
import org.apache.dubbo.remoting.transport.ChannelHandlerDispatcher;

public class Transporters {
    private Transporters() {
    }

    public static RemotingServer bind(String url, ChannelHandler ... handler) throws RemotingException {
        return Transporters.bind(URL.valueOf((String)url), handler);
    }

    public static RemotingServer bind(URL url, ChannelHandler ... handlers) throws RemotingException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handlers == null || handlers.length == 0) {
            throw new IllegalArgumentException("handlers == null");
        }
        ChannelHandler handler = handlers.length == 1 ? handlers[0] : new ChannelHandlerDispatcher(handlers);
        return Transporters.getTransporter(url).bind(url, handler);
    }

    public static Client connect(String url, ChannelHandler ... handler) throws RemotingException {
        return Transporters.connect(URL.valueOf((String)url), handler);
    }

    public static Client connect(URL url, ChannelHandler ... handlers) throws RemotingException {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        ChannelHandler handler = handlers == null || handlers.length == 0 ? new ChannelHandlerAdapter() : (handlers.length == 1 ? handlers[0] : new ChannelHandlerDispatcher(handlers));
        return Transporters.getTransporter(url).connect(url, handler);
    }

    public static Transporter getTransporter(URL url) {
        return (Transporter)url.getOrDefaultFrameworkModel().getExtensionLoader(Transporter.class).getAdaptiveExtension();
    }

    static {
        Version.checkDuplicate(Transporters.class);
        Version.checkDuplicate(RemotingException.class);
    }
}

