/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport;

import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Client;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.AbstractEndpoint;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractClient
extends AbstractEndpoint
implements Client {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractClient.class);
    private final Lock connectLock = new ReentrantLock();
    private final boolean needReconnect;
    protected volatile ExecutorService executor;

    public AbstractClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
        this.needReconnect = url.getParameter("send.reconnect", true);
        this.initExecutor(url);
        try {
            this.doOpen();
        }
        catch (Throwable t) {
            this.close();
            throw new RemotingException(url.toInetSocketAddress(), null, "Failed to start " + this.getClass().getSimpleName() + " " + NetUtils.getLocalAddress() + " connect to the server " + this.getRemoteAddress() + ", cause: " + t.getMessage(), t);
        }
        try {
            this.connect();
            if (logger.isInfoEnabled()) {
                logger.info("Start " + this.getClass().getSimpleName() + " " + NetUtils.getLocalAddress() + " connect to the server " + this.getRemoteAddress());
            }
        }
        catch (RemotingException t) {
            if (url.getParameter("lazy", false)) {
                logger.warn("6-1", "", "", "Failed to start " + this.getClass().getSimpleName() + " " + NetUtils.getLocalAddress() + " connect to the server " + this.getRemoteAddress() + " (the connection request is initiated by lazy connect client, ignore and retry later!), cause: " + t.getMessage(), (Throwable)t);
                return;
            }
            if (url.getParameter("check", true)) {
                this.close();
                throw t;
            }
            logger.warn("6-1", "", "", "Failed to start " + this.getClass().getSimpleName() + " " + NetUtils.getLocalAddress() + " connect to the server " + this.getRemoteAddress() + " (check == false, ignore and retry later!), cause: " + t.getMessage(), (Throwable)t);
        }
        catch (Throwable t) {
            this.close();
            throw new RemotingException(url.toInetSocketAddress(), null, "Failed to start " + this.getClass().getSimpleName() + " " + NetUtils.getLocalAddress() + " connect to the server " + this.getRemoteAddress() + ", cause: " + t.getMessage(), t);
        }
    }

    private void initExecutor(URL url) {
        ExecutorRepository executorRepository = ExecutorRepository.getInstance((ApplicationModel)url.getOrDefaultApplicationModel());
        url = url.addParameter("threadname", "DubboClientHandler").addParameterIfAbsent("threadpool", "cached");
        this.executor = executorRepository.createExecutorIfAbsent(url);
    }

    protected static ChannelHandler wrapChannelHandler(URL url, ChannelHandler handler) {
        return ChannelHandlers.wrap(handler, url);
    }

    public InetSocketAddress getConnectAddress() {
        return new InetSocketAddress(NetUtils.filterLocalHost((String)this.getUrl().getHost()), this.getUrl().getPort());
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        Channel channel = this.getChannel();
        if (channel == null) {
            return this.getUrl().toInetSocketAddress();
        }
        return channel.getRemoteAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        Channel channel = this.getChannel();
        if (channel == null) {
            return InetSocketAddress.createUnresolved(NetUtils.getLocalHost(), 0);
        }
        return channel.getLocalAddress();
    }

    @Override
    public boolean isConnected() {
        Channel channel = this.getChannel();
        if (channel == null) {
            return false;
        }
        return channel.isConnected();
    }

    @Override
    public Object getAttribute(String key) {
        Channel channel = this.getChannel();
        if (channel == null) {
            return null;
        }
        return channel.getAttribute(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        Channel channel = this.getChannel();
        if (channel == null) {
            return;
        }
        channel.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        Channel channel = this.getChannel();
        if (channel == null) {
            return;
        }
        channel.removeAttribute(key);
    }

    @Override
    public boolean hasAttribute(String key) {
        Channel channel = this.getChannel();
        if (channel == null) {
            return false;
        }
        return channel.hasAttribute(key);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        Channel channel;
        if (this.needReconnect && !this.isConnected()) {
            this.connect();
        }
        if ((channel = this.getChannel()) == null || !channel.isConnected()) {
            throw new RemotingException((Channel)this, "message can not send, because channel is closed . url:" + this.getUrl());
        }
        channel.send(message, sent);
    }

    protected void connect() throws RemotingException {
        this.connectLock.lock();
        try {
            if (this.isConnected()) {
                return;
            }
            if (this.isClosed() || this.isClosing()) {
                logger.warn("6-1", "", "", "No need to connect to server " + this.getRemoteAddress() + " from " + this.getClass().getSimpleName() + " " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion() + ", cause: client status is closed or closing.");
                return;
            }
            this.doConnect();
            if (!this.isConnected()) {
                throw new RemotingException((Channel)this, "Failed to connect to server " + this.getRemoteAddress() + " from " + this.getClass().getSimpleName() + " " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion() + ", cause: Connect wait timeout: " + this.getConnectTimeout() + "ms.");
            }
            if (logger.isInfoEnabled()) {
                logger.info("Successfully connect to server " + this.getRemoteAddress() + " from " + this.getClass().getSimpleName() + " " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion() + ", channel is " + this.getChannel());
            }
        }
        catch (RemotingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RemotingException(this, "Failed to connect to server " + this.getRemoteAddress() + " from " + this.getClass().getSimpleName() + " " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion() + ", cause: " + e.getMessage(), e);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    public void disconnect() {
        this.connectLock.lock();
        try {
            try {
                Channel channel = this.getChannel();
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Throwable e) {
                logger.warn("6-3", "", "", e.getMessage(), e);
            }
            try {
                this.doDisConnect();
            }
            catch (Throwable e) {
                logger.warn("6-3", "", "", e.getMessage(), e);
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public void reconnect() throws RemotingException {
        this.connectLock.lock();
        try {
            this.disconnect();
            this.connect();
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            logger.warn("6-1", "", "", "No need to close connection to server " + this.getRemoteAddress() + " from " + this.getClass().getSimpleName() + " " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion() + ", cause: the client status is closed.");
            return;
        }
        this.connectLock.lock();
        try {
            if (this.isClosed()) {
                logger.warn("6-1", "", "", "No need to close connection to server " + this.getRemoteAddress() + " from " + this.getClass().getSimpleName() + " " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion() + ", cause: the client status is closed.");
                return;
            }
            try {
                super.close();
            }
            catch (Throwable e) {
                logger.warn("6-3", "", "", e.getMessage(), e);
            }
            try {
                this.disconnect();
            }
            catch (Throwable e) {
                logger.warn("6-3", "", "", e.getMessage(), e);
            }
            try {
                this.doClose();
            }
            catch (Throwable e) {
                logger.warn("6-3", "", "", e.getMessage(), e);
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public void close(int timeout) {
        this.close();
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getLocalAddress() + " -> " + this.getRemoteAddress() + "]";
    }

    protected abstract void doOpen() throws Throwable;

    protected abstract void doClose() throws Throwable;

    protected abstract void doConnect() throws Throwable;

    protected abstract void doDisConnect() throws Throwable;

    protected abstract Channel getChannel();
}

