/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.AbstractChannel;
import org.apache.dubbo.remoting.transport.netty.NettyClient;
import org.apache.dubbo.remoting.utils.PayloadDropper;
import org.jboss.netty.channel.ChannelFuture;

final class NettyChannel
extends AbstractChannel {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NettyChannel.class);
    private static final ConcurrentMap<org.jboss.netty.channel.Channel, NettyChannel> CHANNEL_MAP = new ConcurrentHashMap<org.jboss.netty.channel.Channel, NettyChannel>();
    private final org.jboss.netty.channel.Channel channel;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    private NettyChannel(org.jboss.netty.channel.Channel channel, URL url, ChannelHandler handler) {
        super(url, handler);
        if (channel == null) {
            throw new IllegalArgumentException("netty channel == null;");
        }
        this.channel = channel;
    }

    static NettyChannel getOrAddChannel(org.jboss.netty.channel.Channel ch, URL url, ChannelHandler handler) {
        if (ch == null) {
            return null;
        }
        NettyChannel ret = (NettyChannel)((Object)CHANNEL_MAP.get(ch));
        if (ret == null) {
            NettyChannel nc = new NettyChannel(ch, url, handler);
            if (ch.isConnected()) {
                ret = CHANNEL_MAP.putIfAbsent(ch, nc);
            }
            if (ret == null) {
                ret = nc;
            }
        }
        return ret;
    }

    static void removeChannelIfDisconnected(org.jboss.netty.channel.Channel ch) {
        if (ch != null && !ch.isConnected()) {
            CHANNEL_MAP.remove(ch);
        }
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public void send(Object message, boolean sent) throws RemotingException {
        super.send(message, sent);
        boolean success = true;
        int timeout = 0;
        try {
            Throwable cause;
            ChannelFuture future = this.channel.write(message);
            if (sent) {
                timeout = this.getUrl().getPositiveParameter("timeout", 1000);
                success = future.await((long)timeout);
            }
            if ((cause = future.getCause()) != null) {
                throw cause;
            }
        }
        catch (Throwable e) {
            throw new RemotingException((Channel)this, "Failed to send message " + PayloadDropper.getRequestWithoutData((Object)message) + " to " + this.getRemoteAddress() + ", cause: " + e.getMessage(), e);
        }
        if (!success) {
            throw new RemotingException((Channel)this, "Failed to send message " + PayloadDropper.getRequestWithoutData((Object)message) + " to " + this.getRemoteAddress() + "in timeout(" + timeout + "ms) limit");
        }
    }

    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            logger.warn("6-3", "", "", e.getMessage(), (Throwable)e);
        }
        try {
            NettyChannel.removeChannelIfDisconnected(this.channel);
        }
        catch (Exception e) {
            logger.warn("6-3", "", "", e.getMessage(), (Throwable)e);
        }
        try {
            this.attributes.clear();
        }
        catch (Exception e) {
            logger.warn("6-3", "", "", e.getMessage(), (Throwable)e);
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Close netty channel " + this.channel);
            }
            this.channel.close();
        }
        catch (Exception e) {
            logger.warn("6-3", "", "", e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NettyClient) {
            NettyClient client = (NettyClient)((Object)obj);
            return this.channel.equals(client.getNettyChannel());
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        NettyChannel other = (NettyChannel)((Object)obj);
        return !(this.channel == null ? other.channel != null : !this.channel.equals(other.channel));
    }

    public String toString() {
        return "NettyChannel [channel=" + this.channel + "]";
    }
}

