/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import com.alibaba.dubbo.rpc.service.EchoService;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.Destroyable;
import org.apache.dubbo.rpc.service.GenericService;

public abstract class AbstractProxyFactory
implements ProxyFactory {
    private static final Class<?>[] INTERNAL_INTERFACES = new Class[]{EchoService.class, Destroyable.class};

    @Override
    public <T> T getProxy(Invoker<T> invoker) throws RpcException {
        return this.getProxy(invoker, false);
    }

    @Override
    public <T> T getProxy(Invoker<T> invoker, boolean generic) throws RpcException {
        String[] types;
        HashSet interfaces = new HashSet();
        String config = invoker.getUrl().getParameter("interfaces");
        if (config != null && config.length() > 0 && (types = CommonConstants.COMMA_SPLIT_PATTERN.split(config)) != null && types.length > 0) {
            for (int i = 0; i < types.length; ++i) {
                interfaces.add(ReflectUtils.forName((String)types[i]));
            }
        }
        if (!GenericService.class.isAssignableFrom(invoker.getInterface()) && generic) {
            interfaces.add(com.alibaba.dubbo.rpc.service.GenericService.class);
        }
        interfaces.add(invoker.getInterface());
        interfaces.addAll(Arrays.asList(INTERNAL_INTERFACES));
        return this.getProxy(invoker, interfaces.toArray(new Class[0]));
    }

    public abstract <T> T getProxy(Invoker<T> var1, Class<?>[] var2);
}

