/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util.protocol.delta;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.xds.util.protocol.DeltaResource;
import org.apache.dubbo.registry.xds.util.protocol.message.Endpoint;
import org.apache.dubbo.registry.xds.util.protocol.message.EndpointResult;

public class DeltaEndpoint
implements DeltaResource<EndpointResult> {
    private final Map<String, Set<Endpoint>> data = new ConcurrentHashMap<String, Set<Endpoint>>();

    public void addResource(String resourceName, Set<Endpoint> endpoints) {
        this.data.put(resourceName, endpoints);
    }

    public void removeResource(Collection<String> resourceName) {
        if (CollectionUtils.isNotEmpty(resourceName)) {
            resourceName.forEach(this.data::remove);
        }
    }

    @Override
    public EndpointResult getResource() {
        Set<Endpoint> set = this.data.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return new EndpointResult(set);
    }
}

