/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util.protocol.impl;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.config.route.v3.Route;
import io.envoyproxy.envoy.config.route.v3.RouteAction;
import io.envoyproxy.envoy.config.route.v3.RouteConfiguration;
import io.envoyproxy.envoy.config.route.v3.VirtualHost;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.xds.util.AdsObserver;
import org.apache.dubbo.registry.xds.util.protocol.AbstractProtocol;
import org.apache.dubbo.registry.xds.util.protocol.delta.DeltaRoute;
import org.apache.dubbo.registry.xds.util.protocol.message.RouteResult;

public class RdsProtocol
extends AbstractProtocol<RouteResult, DeltaRoute> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RdsProtocol.class);

    public RdsProtocol(AdsObserver adsObserver, Node node, int checkInterval) {
        super(adsObserver, node, checkInterval);
    }

    @Override
    public String getTypeUrl() {
        return "type.googleapis.com/envoy.config.route.v3.RouteConfiguration";
    }

    @Override
    protected Map<String, RouteResult> decodeDiscoveryResponse(DiscoveryResponse response) {
        if (this.getTypeUrl().equals(response.getTypeUrl())) {
            return response.getResourcesList().stream().map(RdsProtocol::unpackRouteConfiguration).filter(Objects::nonNull).collect(Collectors.toConcurrentMap(RouteConfiguration::getName, this::decodeResourceToListener));
        }
        return new HashMap<String, RouteResult>();
    }

    private RouteResult decodeResourceToListener(RouteConfiguration resource) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        ConcurrentHashMap<String, VirtualHost> rdsVirtualhostMap = new ConcurrentHashMap<String, VirtualHost>();
        resource.getVirtualHostsList().forEach(virtualHost -> {
            Set cluster = virtualHost.getRoutesList().stream().map(Route::getRoute).map(RouteAction::getCluster).collect(Collectors.toSet());
            for (String domain : virtualHost.getDomainsList()) {
                map.put(domain, cluster);
                rdsVirtualhostMap.put(domain, (VirtualHost)virtualHost);
            }
        });
        return new RouteResult(map, rdsVirtualhostMap);
    }

    private static RouteConfiguration unpackRouteConfiguration(Any any) {
        try {
            return (RouteConfiguration)any.unpack(RouteConfiguration.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("1-31", "", "", "Error occur when decode xDS response.", (Throwable)e);
            return null;
        }
    }
}

