/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.NewClusterClient;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.clusterframework.messages.GetClusterStatusResponse;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.util.LeaderConnectionInfo;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedValue;
import scala.concurrent.duration.FiniteDuration;

public class MiniClusterClient
extends ClusterClient<MiniClusterId>
implements NewClusterClient {
    private final MiniCluster miniCluster;

    public MiniClusterClient(@Nonnull Configuration configuration, @Nonnull MiniCluster miniCluster) {
        super(configuration, miniCluster.getHighAvailabilityServices(), true);
        this.miniCluster = miniCluster;
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
    }

    @Override
    public JobSubmissionResult submitJob(JobGraph jobGraph, ClassLoader classLoader) throws ProgramInvocationException {
        JobResult jobResult;
        CompletableFuture<JobSubmissionResult> jobSubmissionResultFuture = this.submitJob(jobGraph);
        if (this.isDetached()) {
            try {
                return jobSubmissionResultFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ExceptionUtils.checkInterrupted((Throwable)e);
                throw new ProgramInvocationException("Could not run job in detached mode.", jobGraph.getJobID(), e);
            }
        }
        CompletionStage jobResultFuture = jobSubmissionResultFuture.thenCompose(ignored -> this.requestJobResult(jobGraph.getJobID()));
        try {
            jobResult = (JobResult)((CompletableFuture)jobResultFuture).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ExceptionUtils.checkInterrupted((Throwable)e);
            throw new ProgramInvocationException("Could not run job", jobGraph.getJobID(), e);
        }
        try {
            return jobResult.toJobExecutionResult(classLoader);
        }
        catch (JobResult.WrappedJobException e) {
            throw new ProgramInvocationException("Job failed", jobGraph.getJobID(), e.getCause());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ProgramInvocationException("Job failed", jobGraph.getJobID(), e);
        }
    }

    @Override
    public CompletableFuture<JobSubmissionResult> submitJob(@Nonnull JobGraph jobGraph) {
        return this.miniCluster.submitJob(jobGraph);
    }

    @Override
    public CompletableFuture<JobResult> requestJobResult(@Nonnull JobID jobId) {
        return this.miniCluster.requestJobResult(jobId);
    }

    @Override
    public void cancel(JobID jobId) throws Exception {
        this.miniCluster.cancelJob(jobId).get();
    }

    @Override
    public String cancelWithSavepoint(JobID jobId, @Nullable String savepointDirectory) throws Exception {
        return (String)this.miniCluster.triggerSavepoint(jobId, savepointDirectory, true).get();
    }

    @Override
    public void stop(JobID jobId) throws Exception {
        this.miniCluster.stopJob(jobId).get();
    }

    @Override
    public CompletableFuture<String> triggerSavepoint(JobID jobId, @Nullable String savepointDirectory) {
        return this.miniCluster.triggerSavepoint(jobId, savepointDirectory, false);
    }

    @Override
    public CompletableFuture<Acknowledge> disposeSavepoint(String savepointPath) {
        return this.miniCluster.disposeSavepoint(savepointPath);
    }

    @Override
    public CompletableFuture<Collection<JobStatusMessage>> listJobs() {
        return this.miniCluster.listJobs();
    }

    @Override
    public Map<String, OptionalFailure<Object>> getAccumulators(JobID jobID) throws Exception {
        return this.getAccumulators(jobID, ClassLoader.getSystemClassLoader());
    }

    @Override
    public Map<String, OptionalFailure<Object>> getAccumulators(JobID jobID, ClassLoader loader) throws Exception {
        AccessExecutionGraph executionGraph = (AccessExecutionGraph)this.miniCluster.getExecutionGraph(jobID).get();
        Map accumulatorsSerialized = executionGraph.getAccumulatorsSerialized();
        HashMap<String, OptionalFailure<Object>> result = new HashMap<String, OptionalFailure<Object>>(accumulatorsSerialized.size());
        for (Map.Entry acc : accumulatorsSerialized.entrySet()) {
            result.put((String)acc.getKey(), (OptionalFailure<Object>)((SerializedValue)acc.getValue()).deserializeValue(loader));
        }
        return result;
    }

    @Override
    public CompletableFuture<JobStatus> getJobStatus(JobID jobId) {
        return this.miniCluster.getJobStatus(jobId);
    }

    @Override
    public MiniClusterId getClusterId() {
        return MiniClusterId.INSTANCE;
    }

    @Override
    public LeaderConnectionInfo getClusterConnectionInfo() throws LeaderRetrievalException {
        return LeaderRetrievalUtils.retrieveLeaderConnectionInfo((LeaderRetrievalService)this.highAvailabilityServices.getDispatcherLeaderRetriever(), (FiniteDuration)this.timeout);
    }

    @Override
    public void waitForClusterToBeReady() {
    }

    @Override
    public String getWebInterfaceURL() {
        return this.miniCluster.getRestAddress().toString();
    }

    @Override
    public GetClusterStatusResponse getClusterStatus() {
        return null;
    }

    @Override
    public List<String> getNewMessages() {
        return Collections.emptyList();
    }

    @Override
    public int getMaxSlots() {
        return -1;
    }

    @Override
    public boolean hasUserJarsInClassPath(List<URL> userJarFiles) {
        return false;
    }

    static enum MiniClusterId {
        INSTANCE;

    }
}

