/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import java.net.URI;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.common.Program;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.JobExecutorService;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;

public class LocalExecutor
extends PlanExecutor {
    private static final boolean DEFAULT_OVERWRITE = false;
    private static final int DEFAULT_TASK_MANAGER_NUM_SLOTS = -1;
    private final Object lock = new Object();
    private final Configuration baseConfiguration;
    private JobExecutorService jobExecutorService;
    private Configuration jobExecutorServiceConfiguration;
    private int taskManagerNumSlots = -1;
    private boolean defaultOverwriteFiles = false;

    public LocalExecutor() {
        this(null);
    }

    public LocalExecutor(Configuration conf) {
        this.baseConfiguration = conf != null ? conf : new Configuration();
    }

    public boolean isDefaultOverwriteFiles() {
        return this.defaultOverwriteFiles;
    }

    public void setDefaultOverwriteFiles(boolean defaultOverwriteFiles) {
        this.defaultOverwriteFiles = defaultOverwriteFiles;
    }

    public void setTaskManagerNumSlots(int taskManagerNumSlots) {
        this.taskManagerNumSlots = taskManagerNumSlots;
    }

    public int getTaskManagerNumSlots() {
        return this.taskManagerNumSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.jobExecutorService != null) {
                throw new IllegalStateException("The local executor was already started.");
            }
            this.jobExecutorServiceConfiguration = this.createConfiguration();
            this.jobExecutorService = this.createJobExecutorService(this.jobExecutorServiceConfiguration);
        }
    }

    private JobExecutorService createJobExecutorService(Configuration configuration) throws Exception {
        if (!configuration.contains(RestOptions.BIND_PORT)) {
            configuration.setString(RestOptions.BIND_PORT, "0");
        }
        MiniClusterConfiguration miniClusterConfiguration = new MiniClusterConfiguration.Builder().setConfiguration(configuration).setNumTaskManagers(configuration.getInteger("local.number-taskmanager", 1)).setRpcServiceSharing(RpcServiceSharing.SHARED).setNumSlotsPerTaskManager(configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, 1)).build();
        MiniCluster miniCluster = new MiniCluster(miniClusterConfiguration);
        miniCluster.start();
        configuration.setInteger(RestOptions.PORT, ((URI)miniCluster.getRestAddress().get()).getPort());
        return miniCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.jobExecutorService != null) {
                this.jobExecutorService.close();
                this.jobExecutorService = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.jobExecutorService != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecutionResult executePlan(Plan plan) throws Exception {
        if (plan == null) {
            throw new IllegalArgumentException("The plan may not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            JobExecutionResult jobExecutionResult;
            block11: {
                boolean shutDownAtEnd;
                if (this.jobExecutorService == null) {
                    int maxParallelism;
                    shutDownAtEnd = true;
                    if (this.taskManagerNumSlots == -1 && (maxParallelism = plan.getMaximumParallelism()) > 0) {
                        this.taskManagerNumSlots = maxParallelism;
                    }
                    this.start();
                } else {
                    shutDownAtEnd = false;
                }
                try {
                    int slotsPerTaskManager = this.jobExecutorServiceConfiguration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, this.taskManagerNumSlots);
                    int numTaskManagers = this.jobExecutorServiceConfiguration.getInteger("local.number-taskmanager", 1);
                    plan.setDefaultParallelism(slotsPerTaskManager * numTaskManagers);
                    Optimizer pc = new Optimizer(new DataStatistics(), this.jobExecutorServiceConfiguration);
                    OptimizedPlan op = pc.compile(plan);
                    JobGraphGenerator jgg = new JobGraphGenerator(this.jobExecutorServiceConfiguration);
                    JobGraph jobGraph = jgg.compileJobGraph(op, plan.getJobId());
                    jobExecutionResult = this.jobExecutorService.executeJobBlocking(jobGraph);
                    if (!shutDownAtEnd) break block11;
                }
                catch (Throwable throwable) {
                    if (shutDownAtEnd) {
                        this.stop();
                    }
                    throw throwable;
                }
                this.stop();
            }
            return jobExecutionResult;
        }
    }

    public String getOptimizerPlanAsJSON(Plan plan) throws Exception {
        int parallelism = plan.getDefaultParallelism() == -1 ? 1 : plan.getDefaultParallelism();
        Optimizer pc = new Optimizer(new DataStatistics(), this.baseConfiguration);
        pc.setDefaultParallelism(parallelism);
        OptimizedPlan op = pc.compile(plan);
        return new PlanJSONDumpGenerator().getOptimizerPlanAsJSON(op);
    }

    public void endSession(JobID jobID) throws Exception {
    }

    private Configuration createConfiguration() {
        Configuration newConfiguration = new Configuration();
        newConfiguration.setInteger(TaskManagerOptions.NUM_TASK_SLOTS, this.getTaskManagerNumSlots());
        newConfiguration.setBoolean(CoreOptions.FILESYTEM_DEFAULT_OVERRIDE, this.isDefaultOverwriteFiles());
        newConfiguration.addAll(this.baseConfiguration);
        return newConfiguration;
    }

    public static JobExecutionResult execute(Program pa, String ... args) throws Exception {
        return LocalExecutor.execute(pa.getPlan(args));
    }

    public static JobExecutionResult execute(Plan plan) throws Exception {
        return new LocalExecutor().executePlan(plan);
    }

    public static String optimizerPlanAsJSON(Plan plan) throws Exception {
        int parallelism = plan.getDefaultParallelism() == -1 ? 1 : plan.getDefaultParallelism();
        Optimizer pc = new Optimizer(new DataStatistics(), new Configuration());
        pc.setDefaultParallelism(parallelism);
        OptimizedPlan op = pc.compile(plan);
        return new PlanJSONDumpGenerator().getOptimizerPlanAsJSON(op);
    }

    public static String getPlanAsJSON(Plan plan) {
        List sinks = Optimizer.createPreOptimizedPlan((Plan)plan);
        return new PlanJSONDumpGenerator().getPactPlanAsJSON(sinks);
    }
}

