/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase1.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.sink.HBaseMutationConverter;
import org.apache.flink.connector.hbase.sink.HBaseSinkFunction;
import org.apache.flink.connector.hbase.sink.RowDataToMutationConverter;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.types.RowKind;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBaseDynamicTableSink
implements DynamicTableSink {
    private final HBaseTableSchema hbaseTableSchema;
    private final String nullStringLiteral;
    private final Configuration hbaseConf;
    private final HBaseWriteOptions writeOptions;
    private final String tableName;

    public HBaseDynamicTableSink(String tableName, HBaseTableSchema hbaseTableSchema, Configuration hbaseConf, HBaseWriteOptions writeOptions, String nullStringLiteral) {
        this.hbaseTableSchema = hbaseTableSchema;
        this.nullStringLiteral = nullStringLiteral;
        this.hbaseConf = hbaseConf;
        this.writeOptions = writeOptions;
        this.tableName = tableName;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        HBaseSinkFunction sinkFunction = new HBaseSinkFunction(this.tableName, this.hbaseConf, (HBaseMutationConverter)new RowDataToMutationConverter(this.hbaseTableSchema, this.nullStringLiteral), this.writeOptions.getBufferFlushMaxSizeInBytes(), this.writeOptions.getBufferFlushMaxRows(), this.writeOptions.getBufferFlushIntervalMillis());
        return SinkFunctionProvider.of((SinkFunction)sinkFunction, (Integer)this.writeOptions.getParallelism());
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            if (kind == RowKind.UPDATE_BEFORE) continue;
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public DynamicTableSink copy() {
        return new HBaseDynamicTableSink(this.tableName, this.hbaseTableSchema, this.hbaseConf, this.writeOptions, this.nullStringLiteral);
    }

    public String asSummaryString() {
        return "HBase";
    }

    @VisibleForTesting
    public HBaseTableSchema getHBaseTableSchema() {
        return this.hbaseTableSchema;
    }

    @VisibleForTesting
    public HBaseWriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    @VisibleForTesting
    public Configuration getConfiguration() {
        return this.hbaseConf;
    }

    @VisibleForTesting
    public String getTableName() {
        return this.tableName;
    }
}

