/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.table.HBaseConnectorOptions;
import org.apache.flink.connector.hbase.table.HBaseConnectorOptionsUtil;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase2.sink.HBaseDynamicTableSink;
import org.apache.flink.connector.hbase2.source.HBaseDynamicTableSource;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.lookup.LookupOptions;
import org.apache.flink.table.connector.source.lookup.cache.DefaultLookupCache;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBase2DynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private static final String IDENTIFIER = "hbase-2.2";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        HBaseConnectorOptionsUtil.validatePrimaryKey((DataType)context.getPhysicalRowDataType(), (int[])context.getPrimaryKeyIndexes());
        String tableName = (String)tableOptions.get(HBaseConnectorOptions.TABLE_NAME);
        Configuration hbaseConf = HBaseConnectorOptionsUtil.getHBaseConfiguration((ReadableConfig)tableOptions);
        String nullStringLiteral = (String)tableOptions.get(HBaseConnectorOptions.NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromDataType((DataType)context.getPhysicalRowDataType());
        DefaultLookupCache cache = null;
        if ((Long)tableOptions.get(HBaseConnectorOptions.LOOKUP_CACHE_MAX_ROWS) > 0L && ((Duration)tableOptions.get(HBaseConnectorOptions.LOOKUP_CACHE_TTL)).compareTo(Duration.ZERO) > 0) {
            cache = DefaultLookupCache.newBuilder().maximumSize(((Long)tableOptions.get(HBaseConnectorOptions.LOOKUP_CACHE_MAX_ROWS)).longValue()).expireAfterWrite((Duration)tableOptions.get(HBaseConnectorOptions.LOOKUP_CACHE_TTL)).build();
        }
        if (((LookupOptions.LookupCacheType)tableOptions.get(LookupOptions.CACHE_TYPE)).equals((Object)LookupOptions.LookupCacheType.PARTIAL)) {
            cache = DefaultLookupCache.fromConfig((ReadableConfig)tableOptions);
        }
        return new HBaseDynamicTableSource(hbaseConf, tableName, hbaseSchema, nullStringLiteral, (Integer)tableOptions.get(LookupOptions.MAX_RETRIES), (Boolean)tableOptions.get(HBaseConnectorOptions.LOOKUP_ASYNC), (LookupCache)cache);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        HBaseConnectorOptionsUtil.validatePrimaryKey((DataType)context.getPhysicalRowDataType(), (int[])context.getPrimaryKeyIndexes());
        String tableName = (String)tableOptions.get(HBaseConnectorOptions.TABLE_NAME);
        Configuration hbaseConf = HBaseConnectorOptionsUtil.getHBaseConfiguration((ReadableConfig)tableOptions);
        HBaseWriteOptions hBaseWriteOptions = HBaseConnectorOptionsUtil.getHBaseWriteOptions((ReadableConfig)tableOptions);
        String nullStringLiteral = (String)tableOptions.get(HBaseConnectorOptions.NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromDataType((DataType)context.getPhysicalRowDataType());
        return new HBaseDynamicTableSink(tableName, hbaseSchema, hbaseConf, hBaseWriteOptions, nullStringLiteral);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet set = new HashSet();
        set.add(HBaseConnectorOptions.TABLE_NAME);
        return set;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet set = new HashSet();
        set.add(HBaseConnectorOptions.ZOOKEEPER_ZNODE_PARENT);
        set.add(HBaseConnectorOptions.ZOOKEEPER_QUORUM);
        set.add(HBaseConnectorOptions.NULL_STRING_LITERAL);
        set.add(HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_SIZE);
        set.add(HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        set.add(HBaseConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL);
        set.add(HBaseConnectorOptions.SINK_PARALLELISM);
        set.add(HBaseConnectorOptions.LOOKUP_ASYNC);
        set.add(HBaseConnectorOptions.LOOKUP_CACHE_MAX_ROWS);
        set.add(HBaseConnectorOptions.LOOKUP_CACHE_TTL);
        set.add(HBaseConnectorOptions.LOOKUP_MAX_RETRIES);
        set.add(LookupOptions.CACHE_TYPE);
        set.add(LookupOptions.MAX_RETRIES);
        set.add(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_ACCESS);
        set.add(LookupOptions.PARTIAL_CACHE_EXPIRE_AFTER_WRITE);
        set.add(LookupOptions.PARTIAL_CACHE_CACHE_MISSING_KEY);
        set.add(LookupOptions.PARTIAL_CACHE_MAX_ROWS);
        return set;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(HBaseConnectorOptions.TABLE_NAME, HBaseConnectorOptions.ZOOKEEPER_ZNODE_PARENT, HBaseConnectorOptions.ZOOKEEPER_QUORUM, HBaseConnectorOptions.NULL_STRING_LITERAL, HBaseConnectorOptions.LOOKUP_CACHE_MAX_ROWS, HBaseConnectorOptions.LOOKUP_CACHE_TTL, HBaseConnectorOptions.LOOKUP_MAX_RETRIES, HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_SIZE, HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS, HBaseConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL).collect(Collectors.toSet());
    }
}

