/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.testutils;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.connectors.kafka.internals.AbstractPartitionDiscoverer;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicsDescriptor;
import org.assertj.core.api.Assertions;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestPartitionDiscoverer
extends AbstractPartitionDiscoverer {
    private final KafkaTopicsDescriptor topicsDescriptor;
    private final List<List<String>> mockGetAllTopicsReturnSequence;
    private final List<List<KafkaTopicPartition>> mockGetAllPartitionsForTopicsReturnSequence;
    private int getAllTopicsInvokeCount = 0;
    private int getAllPartitionsForTopicsInvokeCount = 0;

    public TestPartitionDiscoverer(KafkaTopicsDescriptor topicsDescriptor, int indexOfThisSubtask, int numParallelSubtasks, List<List<String>> mockGetAllTopicsReturnSequence, List<List<KafkaTopicPartition>> mockGetAllPartitionsForTopicsReturnSequence) {
        super(topicsDescriptor, indexOfThisSubtask, numParallelSubtasks);
        this.topicsDescriptor = topicsDescriptor;
        this.mockGetAllTopicsReturnSequence = mockGetAllTopicsReturnSequence;
        this.mockGetAllPartitionsForTopicsReturnSequence = mockGetAllPartitionsForTopicsReturnSequence;
    }

    protected List<String> getAllTopics() {
        Assertions.assertThat((boolean)this.topicsDescriptor.isTopicPattern()).isTrue();
        return this.mockGetAllTopicsReturnSequence.get(this.getAllTopicsInvokeCount++);
    }

    protected List<KafkaTopicPartition> getAllPartitionsForTopics(List<String> topics) {
        if (this.topicsDescriptor.isFixedTopics()) {
            Assertions.assertThat(topics).isEqualTo((Object)this.topicsDescriptor.getFixedTopics());
        } else {
            Assertions.assertThat(topics).isEqualTo(this.mockGetAllTopicsReturnSequence.get(this.getAllPartitionsForTopicsInvokeCount - 1));
        }
        return this.mockGetAllPartitionsForTopicsReturnSequence.get(this.getAllPartitionsForTopicsInvokeCount++);
    }

    protected void initializeConnections() {
    }

    protected void wakeupConnections() {
    }

    protected void closeConnections() {
    }

    public static List<List<String>> createMockGetAllTopicsSequenceFromFixedReturn(final List<String> fixed) {
        List mockSequence = (List)Mockito.mock(List.class);
        Mockito.when(mockSequence.get(Matchers.anyInt())).thenAnswer((Answer)new Answer<List<String>>(){

            public List<String> answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new ArrayList<String>(fixed);
            }
        });
        return mockSequence;
    }

    public static List<List<KafkaTopicPartition>> createMockGetAllPartitionsFromTopicsSequenceFromFixedReturn(final List<KafkaTopicPartition> fixed) {
        List mockSequence = (List)Mockito.mock(List.class);
        Mockito.when(mockSequence.get(Matchers.anyInt())).thenAnswer((Answer)new Answer<List<KafkaTopicPartition>>(){

            public List<KafkaTopicPartition> answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new ArrayList<KafkaTopicPartition>(fixed);
            }
        });
        return mockSequence;
    }
}

