/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.testutils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.runtime.client.JobStatusMessage;

public class ClusterCommunicationUtils {
    public static void waitUntilJobIsRunning(ClusterClient<?> client) throws Exception {
        while (ClusterCommunicationUtils.getRunningJobs(client).isEmpty()) {
            Thread.sleep(50L);
        }
    }

    public static void waitUntilNoJobIsRunning(ClusterClient<?> client) throws Exception {
        while (!ClusterCommunicationUtils.getRunningJobs(client).isEmpty()) {
            Thread.sleep(50L);
        }
    }

    public static List<JobID> getRunningJobs(ClusterClient<?> client) throws Exception {
        Collection statusMessages = (Collection)client.listJobs().get();
        return statusMessages.stream().filter(status -> !status.getJobState().isGloballyTerminalState()).map(JobStatusMessage::getJobId).collect(Collectors.toList());
    }

    private ClusterCommunicationUtils() {
    }
}

