/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.csv.CsvOptions;
import org.apache.flink.formats.csv.CsvRowDataDeserializationSchema;
import org.apache.flink.formats.csv.CsvRowDataSerializationSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public final class CsvFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "csv";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        CsvFormatFactory.validateFormatOptions(formatOptions);
        return new DecodingFormat<DeserializationSchema<RowData>>(){

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
                RowType rowType = (RowType)producedDataType.getLogicalType();
                TypeInformation rowDataTypeInfo = context.createTypeInformation(producedDataType);
                CsvRowDataDeserializationSchema.Builder schemaBuilder = new CsvRowDataDeserializationSchema.Builder(rowType, (TypeInformation<RowData>)rowDataTypeInfo);
                CsvFormatFactory.configureDeserializationSchema(formatOptions, schemaBuilder);
                return schemaBuilder.build();
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        CsvFormatFactory.validateFormatOptions(formatOptions);
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType rowType = (RowType)consumedDataType.getLogicalType();
                CsvRowDataSerializationSchema.Builder schemaBuilder = new CsvRowDataSerializationSchema.Builder(rowType);
                CsvFormatFactory.configureSerializationSchema(formatOptions, schemaBuilder);
                return schemaBuilder.build();
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(CsvOptions.FIELD_DELIMITER);
        options.add(CsvOptions.DISABLE_QUOTE_CHARACTER);
        options.add(CsvOptions.QUOTE_CHARACTER);
        options.add(CsvOptions.ALLOW_COMMENTS);
        options.add(CsvOptions.IGNORE_PARSE_ERRORS);
        options.add(CsvOptions.ARRAY_ELEMENT_DELIMITER);
        options.add(CsvOptions.ESCAPE_CHARACTER);
        options.add(CsvOptions.NULL_LITERAL);
        return options;
    }

    static void validateFormatOptions(ReadableConfig tableOptions) {
        boolean hasQuoteCharacter = tableOptions.getOptional(CsvOptions.QUOTE_CHARACTER).isPresent();
        boolean isDisabledQuoteCharacter = (Boolean)tableOptions.get(CsvOptions.DISABLE_QUOTE_CHARACTER);
        if (isDisabledQuoteCharacter && hasQuoteCharacter) {
            throw new ValidationException("Format cannot define a quote character and disabled quote character at the same time.");
        }
        CsvFormatFactory.validateCharacterVal(tableOptions, CsvOptions.FIELD_DELIMITER, true);
        CsvFormatFactory.validateCharacterVal(tableOptions, CsvOptions.ARRAY_ELEMENT_DELIMITER);
        CsvFormatFactory.validateCharacterVal(tableOptions, CsvOptions.QUOTE_CHARACTER);
        CsvFormatFactory.validateCharacterVal(tableOptions, CsvOptions.ESCAPE_CHARACTER);
    }

    private static void validateCharacterVal(ReadableConfig tableOptions, ConfigOption<String> option) {
        CsvFormatFactory.validateCharacterVal(tableOptions, option, false);
    }

    private static void validateCharacterVal(ReadableConfig tableOptions, ConfigOption<String> option, boolean unescape) {
        if (tableOptions.getOptional(option).isPresent()) {
            String value;
            String string = value = unescape ? StringEscapeUtils.unescapeJava((String)((String)tableOptions.get(option))) : (String)tableOptions.get(option);
            if (value.length() != 1) {
                throw new ValidationException(String.format("Option '%s.%s' must be a string with single character, but was: %s", IDENTIFIER, option.key(), tableOptions.get(option)));
            }
        }
    }

    private static void configureDeserializationSchema(ReadableConfig formatOptions, CsvRowDataDeserializationSchema.Builder schemaBuilder) {
        formatOptions.getOptional(CsvOptions.FIELD_DELIMITER).map(delimiter -> Character.valueOf(StringEscapeUtils.unescapeJava((String)delimiter).charAt(0))).ifPresent(schemaBuilder::setFieldDelimiter);
        if (((Boolean)formatOptions.get(CsvOptions.DISABLE_QUOTE_CHARACTER)).booleanValue()) {
            schemaBuilder.disableQuoteCharacter();
        } else {
            formatOptions.getOptional(CsvOptions.QUOTE_CHARACTER).map(quote -> Character.valueOf(quote.charAt(0))).ifPresent(schemaBuilder::setQuoteCharacter);
        }
        formatOptions.getOptional(CsvOptions.ALLOW_COMMENTS).ifPresent(schemaBuilder::setAllowComments);
        formatOptions.getOptional(CsvOptions.IGNORE_PARSE_ERRORS).ifPresent(schemaBuilder::setIgnoreParseErrors);
        formatOptions.getOptional(CsvOptions.ARRAY_ELEMENT_DELIMITER).ifPresent(schemaBuilder::setArrayElementDelimiter);
        formatOptions.getOptional(CsvOptions.ESCAPE_CHARACTER).map(escape -> Character.valueOf(escape.charAt(0))).ifPresent(schemaBuilder::setEscapeCharacter);
        formatOptions.getOptional(CsvOptions.NULL_LITERAL).ifPresent(schemaBuilder::setNullLiteral);
    }

    private static void configureSerializationSchema(ReadableConfig formatOptions, CsvRowDataSerializationSchema.Builder schemaBuilder) {
        formatOptions.getOptional(CsvOptions.FIELD_DELIMITER).map(delimiter -> Character.valueOf(StringEscapeUtils.unescapeJava((String)delimiter).charAt(0))).ifPresent(schemaBuilder::setFieldDelimiter);
        if (((Boolean)formatOptions.get(CsvOptions.DISABLE_QUOTE_CHARACTER)).booleanValue()) {
            schemaBuilder.disableQuoteCharacter();
        } else {
            formatOptions.getOptional(CsvOptions.QUOTE_CHARACTER).map(quote -> Character.valueOf(quote.charAt(0))).ifPresent(schemaBuilder::setQuoteCharacter);
        }
        formatOptions.getOptional(CsvOptions.ARRAY_ELEMENT_DELIMITER).ifPresent(schemaBuilder::setArrayElementDelimiter);
        formatOptions.getOptional(CsvOptions.ESCAPE_CHARACTER).map(escape -> Character.valueOf(escape.charAt(0))).ifPresent(schemaBuilder::setEscapeCharacter);
        formatOptions.getOptional(CsvOptions.NULL_LITERAL).ifPresent(schemaBuilder::setNullLiteral);
    }
}

