/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FormatDescriptorValidator;

@Internal
public class CsvValidator
extends FormatDescriptorValidator {
    public static final String FORMAT_TYPE_VALUE = "csv";
    public static final String FORMAT_FIELD_DELIMITER = "format.field-delimiter";
    public static final String FORMAT_LINE_DELIMITER = "format.line-delimiter";
    public static final String FORMAT_DISABLE_QUOTE_CHARACTER = "format.disable-quote-character";
    public static final String FORMAT_QUOTE_CHARACTER = "format.quote-character";
    public static final String FORMAT_ALLOW_COMMENTS = "format.allow-comments";
    public static final String FORMAT_IGNORE_PARSE_ERRORS = "format.ignore-parse-errors";
    public static final String FORMAT_ARRAY_ELEMENT_DELIMITER = "format.array-element-delimiter";
    public static final String FORMAT_ESCAPE_CHARACTER = "format.escape-character";
    public static final String FORMAT_NULL_LITERAL = "format.null-literal";
    public static final String FORMAT_SCHEMA = "format.schema";

    public void validate(DescriptorProperties properties) {
        super.validate(properties);
        properties.validateString(FORMAT_FIELD_DELIMITER, true, 1, 1);
        properties.validateEnumValues(FORMAT_LINE_DELIMITER, true, Arrays.asList("\r", "\n", "\r\n", ""));
        properties.validateBoolean(FORMAT_DISABLE_QUOTE_CHARACTER, true);
        properties.validateString(FORMAT_QUOTE_CHARACTER, true, 1, 1);
        properties.validateBoolean(FORMAT_ALLOW_COMMENTS, true);
        properties.validateBoolean(FORMAT_IGNORE_PARSE_ERRORS, true);
        properties.validateString(FORMAT_ARRAY_ELEMENT_DELIMITER, true, 1);
        properties.validateString(FORMAT_ESCAPE_CHARACTER, true, 1, 1);
        properties.validateBoolean("format.derive-schema", true);
        boolean hasSchema = properties.containsKey(FORMAT_SCHEMA);
        boolean isDerived = properties.getOptionalBoolean("format.derive-schema").orElse(true);
        if (hasSchema) {
            properties.validateType(FORMAT_SCHEMA, false, true);
        } else if (!isDerived) {
            throw new ValidationException("A definition of a schema is required if derivation from the table's schema is disabled.");
        }
        boolean hasQuoteCharacter = properties.containsKey(FORMAT_QUOTE_CHARACTER);
        boolean isDisabledQuoteCharacter = properties.getOptionalBoolean(FORMAT_DISABLE_QUOTE_CHARACTER).orElse(false);
        if (isDisabledQuoteCharacter && hasQuoteCharacter) {
            throw new ValidationException("Format cannot define a quote character and disabled quote character at the same time.");
        }
    }
}

