/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;

public class JsonOptions {
    public static final ConfigOption<Boolean> FAIL_ON_MISSING_FIELD = ConfigOptions.key((String)"fail-on-missing-field").booleanType().defaultValue((Object)false).withDescription("Optional flag to specify whether to fail if a field is missing or not, false by default.");
    public static final ConfigOption<Boolean> IGNORE_PARSE_ERRORS = ConfigOptions.key((String)"ignore-parse-errors").booleanType().defaultValue((Object)false).withDescription("Optional flag to skip fields and rows with parse errors instead of failing;\nfields are set to null in case of errors, false by default.");
    public static final ConfigOption<String> MAP_NULL_KEY_MODE = ConfigOptions.key((String)"map-null-key.mode").stringType().defaultValue((Object)"FAIL").withDescription("Optional flag to control the handling mode when serializing null key for map data, FAIL by default. Option DROP will drop null key entries for map data. Option LITERAL will use 'map-null-key.literal' as key literal.");
    public static final ConfigOption<String> MAP_NULL_KEY_LITERAL = ConfigOptions.key((String)"map-null-key.literal").stringType().defaultValue((Object)"null").withDescription("Optional flag to specify string literal for null keys when 'map-null-key.mode' is LITERAL, \"null\" by default.");
    public static final ConfigOption<String> TIMESTAMP_FORMAT = ConfigOptions.key((String)"timestamp-format.standard").stringType().defaultValue((Object)"SQL").withDescription("Optional flag to specify timestamp format, SQL by default. Option ISO-8601 will parse input timestamp in \"yyyy-MM-ddTHH:mm:ss.s{precision}\" format and output timestamp in the same format. Option SQL will parse input timestamp in \"yyyy-MM-dd HH:mm:ss.s{precision}\" format and output timestamp in the same format.");
    public static final String SQL = "SQL";
    public static final String ISO_8601 = "ISO-8601";
    public static final Set<String> TIMESTAMP_FORMAT_ENUM = new HashSet<String>(Arrays.asList("SQL", "ISO-8601"));
    public static final String JSON_MAP_NULL_KEY_MODE_FAIL = "FAIL";
    public static final String JSON_MAP_NULL_KEY_MODE_DROP = "DROP";
    public static final String JSON_MAP_NULL_KEY_MODE_LITERAL = "LITERAL";

    public static TimestampFormat getTimestampFormat(ReadableConfig config) {
        String timestampFormat;
        switch (timestampFormat = (String)config.get(TIMESTAMP_FORMAT)) {
            case "SQL": {
                return TimestampFormat.SQL;
            }
            case "ISO-8601": {
                return TimestampFormat.ISO_8601;
            }
        }
        throw new TableException(String.format("Unsupported timestamp format '%s'. Validator should have checked that.", timestampFormat));
    }

    public static MapNullKeyMode getMapNullKeyMode(ReadableConfig config) {
        String mapNullKeyMode = (String)config.get(MAP_NULL_KEY_MODE);
        switch (mapNullKeyMode.toUpperCase()) {
            case "FAIL": {
                return MapNullKeyMode.FAIL;
            }
            case "DROP": {
                return MapNullKeyMode.DROP;
            }
            case "LITERAL": {
                return MapNullKeyMode.LITERAL;
            }
        }
        throw new TableException(String.format("Unsupported map null key handling mode '%s'. Validator should have checked that.", mapNullKeyMode));
    }

    public static void validateDecodingFormatOptions(ReadableConfig tableOptions) {
        boolean failOnMissingField = (Boolean)tableOptions.get(FAIL_ON_MISSING_FIELD);
        boolean ignoreParseErrors = (Boolean)tableOptions.get(IGNORE_PARSE_ERRORS);
        if (ignoreParseErrors && failOnMissingField) {
            throw new ValidationException(FAIL_ON_MISSING_FIELD.key() + " and " + IGNORE_PARSE_ERRORS.key() + " shouldn't both be true.");
        }
        JsonOptions.validateTimestampFormat(tableOptions);
    }

    public static void validateEncodingFormatOptions(ReadableConfig tableOptions) {
        Set nullKeyModes = Arrays.stream(MapNullKeyMode.values()).map(Objects::toString).collect(Collectors.toSet());
        if (!nullKeyModes.contains(((String)tableOptions.get(MAP_NULL_KEY_MODE)).toUpperCase())) {
            throw new ValidationException(String.format("Unsupported value '%s' for option %s. Supported values are %s.", tableOptions.get(MAP_NULL_KEY_MODE), MAP_NULL_KEY_MODE.key(), nullKeyModes));
        }
        JsonOptions.validateTimestampFormat(tableOptions);
    }

    static void validateTimestampFormat(ReadableConfig tableOptions) {
        String timestampFormat = (String)tableOptions.get(TIMESTAMP_FORMAT);
        if (!TIMESTAMP_FORMAT_ENUM.contains(timestampFormat)) {
            throw new ValidationException(String.format("Unsupported value '%s' for %s. Supported values are [SQL, ISO-8601].", timestampFormat, TIMESTAMP_FORMAT.key()));
        }
    }

    public static enum MapNullKeyMode {
        FAIL,
        DROP,
        LITERAL;

    }
}

