/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.nio.file.Paths;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.akka.AkkaRpcSystemLoader;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class AkkaRpcSystemLoaderITCase
extends TestLogger {
    private static final AkkaRpcSystemLoader LOADER = new AkkaRpcSystemLoader();
    @ClassRule
    public static final TemporaryFolder TMP_DIR = new TemporaryFolder();

    @Test
    public void testServiceLoadingWithDefaultConfig() {
        Configuration config = new Configuration();
        try (RpcSystem rpcSystem = LOADER.loadRpcSystem(config);){
            MatcherAssert.assertThat((Object)rpcSystem, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void testServiceLoadingWithNonExistingPath() {
        Configuration config = new Configuration();
        config.set(CoreOptions.TMP_DIRS, (Object)TMP_DIR.getRoot().toPath().resolve(Paths.get("some", "directory")).toString());
        try (RpcSystem rpcSystem = LOADER.loadRpcSystem(config);){
            MatcherAssert.assertThat((Object)rpcSystem, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        }
    }
}

