/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.protobuf.ByteString;
import akka.remote.MessageSerializer;
import akka.remote.WireFormats;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.HeaderBuilder;
import akka.remote.artery.OutboundEnvelope;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@InternalApi
public final class MessageSerializer$ {
    public static final MessageSerializer$ MODULE$;

    static {
        new MessageSerializer$();
    }

    public Object deserialize(ExtendedActorSystem system, WireFormats.SerializedMessage messageProtocol) {
        return ((Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)system)).deserialize(messageProtocol.getMessage().toByteArray(), messageProtocol.getSerializerId(), messageProtocol.hasMessageManifest() ? messageProtocol.getMessageManifest().toStringUtf8() : "").get();
    }

    /*
     * WARNING - void declaration
     */
    public WireFormats.SerializedMessage serialize(ExtendedActorSystem system, Object message) {
        WireFormats.SerializedMessage serializedMessage;
        Serialization s = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)system);
        Serializer serializer = s.findSerializerFor(message);
        WireFormats.SerializedMessage.Builder builder = WireFormats.SerializedMessage.newBuilder();
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)system.provider().serializationInformation());
            }
            builder.setMessage(ByteString.copyFrom((byte[])serializer.toBinary(message)));
            builder.setSerializerId(serializer.identifier());
            String ms = Serializers$.MODULE$.manifestFor(serializer, message);
            Object object = new StringOps(Predef$.MODULE$.augmentString(ms)).nonEmpty() ? builder.setMessageManifest(ByteString.copyFromUtf8((String)ms)) : BoxedUnit.UNIT;
            serializedMessage = builder.build();
        }
        catch (Throwable throwable) {
            try {
                void var4_4;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new MessageSerializer.SerializationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to serialize remote message [", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.getClass()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using serializer [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4.getClass()}))).toString(), e);
            }
            catch (Throwable throwable3) {
                void var6_6;
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)var6_6);
                throw throwable3;
            }
        }
        Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        return serializedMessage;
    }

    /*
     * WARNING - void declaration
     */
    public void serializeForArtery(Serialization serialization, OutboundEnvelope outboundEnvelope, HeaderBuilder headerBuilder, EnvelopeBuffer envelope) {
        Serialization.Information oldInfo;
        block4: {
            Object message = outboundEnvelope.message();
            Serializer serializer = serialization.findSerializerFor(message);
            oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
            try {
                if (oldInfo == null) {
                    Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)serialization.serializationInformation());
                }
                headerBuilder.setSerializer(serializer.identifier());
                headerBuilder.setManifest(Serializers$.MODULE$.manifestFor(serializer, message));
                envelope.writeHeader(headerBuilder, outboundEnvelope);
                Serializer serializer2 = serializer;
                if (serializer2 instanceof ByteBufferSerializer) {
                    Serializer serializer3 = serializer2;
                    ((ByteBufferSerializer)serializer3).toBinary(message, envelope.byteBuffer());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                envelope.byteBuffer().put(serializer.toBinary(message));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                void var7_7;
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)var7_7);
                throw throwable;
            }
        }
        Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
    }

    public Object deserializeForArtery(ExtendedActorSystem system, long originUid, Serialization serialization, int serializer, String classManifest, EnvelopeBuffer envelope) {
        return serialization.deserializeByteBuffer(envelope.byteBuffer(), serializer, classManifest);
    }

    private MessageSerializer$() {
        MODULE$ = this;
    }
}

