/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.OperatorIDPair;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorInfo;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingCheckpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointCoordinator.class);
    private final Object lock = new Object();
    private final JobID jobId;
    private final long checkpointId;
    private final long checkpointTimestamp;
    private final Map<OperatorID, OperatorState> operatorStates;
    private final Map<ExecutionAttemptID, ExecutionVertex> notYetAcknowledgedTasks;
    private final Set<OperatorID> notYetAcknowledgedOperatorCoordinators;
    private final List<MasterState> masterStates;
    private final Set<String> notYetAcknowledgedMasterStates;
    private final Set<ExecutionAttemptID> acknowledgedTasks;
    private final CheckpointProperties props;
    private final CheckpointStorageLocation targetLocation;
    private final CompletableFuture<CompletedCheckpoint> onCompletionPromise;
    private final Executor executor;
    private int numAcknowledgedTasks;
    private boolean discarded;
    @Nullable
    private PendingCheckpointStats statsCallback;
    private volatile ScheduledFuture<?> cancellerHandle;
    private CheckpointException failureCause;

    public PendingCheckpoint(JobID jobId, long checkpointId, long checkpointTimestamp, Map<ExecutionAttemptID, ExecutionVertex> verticesToConfirm, Collection<OperatorID> operatorCoordinatorsToConfirm, Collection<String> masterStateIdentifiers, CheckpointProperties props2, CheckpointStorageLocation targetLocation, Executor executor, CompletableFuture<CompletedCheckpoint> onCompletionPromise) {
        Preconditions.checkArgument((verticesToConfirm.size() > 0 ? 1 : 0) != 0, (Object)"Checkpoint needs at least one vertex that commits the checkpoint");
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.checkpointId = checkpointId;
        this.checkpointTimestamp = checkpointTimestamp;
        this.notYetAcknowledgedTasks = (Map)Preconditions.checkNotNull(verticesToConfirm);
        this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props2);
        this.targetLocation = (CheckpointStorageLocation)Preconditions.checkNotNull((Object)targetLocation);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.operatorStates = new HashMap<OperatorID, OperatorState>();
        this.masterStates = new ArrayList<MasterState>(masterStateIdentifiers.size());
        this.notYetAcknowledgedMasterStates = masterStateIdentifiers.isEmpty() ? Collections.emptySet() : new HashSet<String>(masterStateIdentifiers);
        this.notYetAcknowledgedOperatorCoordinators = operatorCoordinatorsToConfirm.isEmpty() ? Collections.emptySet() : new HashSet<OperatorID>(operatorCoordinatorsToConfirm);
        this.acknowledgedTasks = new HashSet<ExecutionAttemptID>(verticesToConfirm.size());
        this.onCompletionPromise = (CompletableFuture)Preconditions.checkNotNull(onCompletionPromise);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public CheckpointStorageLocation getCheckpointStorageLocation() {
        return this.targetLocation;
    }

    public long getCheckpointTimestamp() {
        return this.checkpointTimestamp;
    }

    public int getNumberOfNonAcknowledgedTasks() {
        return this.notYetAcknowledgedTasks.size();
    }

    public int getNumberOfNonAcknowledgedOperatorCoordinators() {
        return this.notYetAcknowledgedOperatorCoordinators.size();
    }

    public int getNumberOfAcknowledgedTasks() {
        return this.numAcknowledgedTasks;
    }

    public Map<OperatorID, OperatorState> getOperatorStates() {
        return this.operatorStates;
    }

    public List<MasterState> getMasterStates() {
        return this.masterStates;
    }

    public boolean isFullyAcknowledged() {
        return this.areTasksFullyAcknowledged() && this.areCoordinatorsFullyAcknowledged() && this.areMasterStatesFullyAcknowledged();
    }

    boolean areMasterStatesFullyAcknowledged() {
        return this.notYetAcknowledgedMasterStates.isEmpty() && !this.discarded;
    }

    boolean areCoordinatorsFullyAcknowledged() {
        return this.notYetAcknowledgedOperatorCoordinators.isEmpty() && !this.discarded;
    }

    boolean areTasksFullyAcknowledged() {
        return this.notYetAcknowledgedTasks.isEmpty() && !this.discarded;
    }

    public boolean isAcknowledgedBy(ExecutionAttemptID executionAttemptId) {
        return !this.notYetAcknowledgedTasks.containsKey((Object)executionAttemptId);
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public boolean canBeSubsumed() {
        return !this.props.isSavepoint();
    }

    CheckpointProperties getProps() {
        return this.props;
    }

    void setStatsCallback(@Nullable PendingCheckpointStats trackerCallback) {
        this.statsCallback = trackerCallback;
    }

    public boolean setCancellerHandle(ScheduledFuture<?> cancellerHandle) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancellerHandle == null) {
                if (!this.discarded) {
                    this.cancellerHandle = cancellerHandle;
                    return true;
                }
                return false;
            }
            throw new IllegalStateException("A canceller handle was already set");
        }
    }

    public CheckpointException getFailureCause() {
        return this.failureCause;
    }

    public CompletableFuture<CompletedCheckpoint> getCompletionFuture() {
        return this.onCompletionPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletedCheckpoint finalizeCheckpoint() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.isDiscarded() ? 1 : 0) != 0, (Object)"checkpoint is discarded");
            Preconditions.checkState((boolean)this.isFullyAcknowledged(), (Object)"Pending checkpoint has not been fully acknowledged yet");
            try {
                CompletedCheckpointStorageLocation finalizedLocation;
                CheckpointMetadata savepoint = new CheckpointMetadata(this.checkpointId, this.operatorStates.values(), this.masterStates);
                try (CheckpointMetadataOutputStream out = this.targetLocation.createMetadataOutputStream();){
                    Checkpoints.storeCheckpointMetadata(savepoint, (OutputStream)((Object)out));
                    finalizedLocation = out.closeAndFinalizeCheckpoint();
                }
                CompletedCheckpoint completed = new CompletedCheckpoint(this.jobId, this.checkpointId, this.checkpointTimestamp, System.currentTimeMillis(), this.operatorStates, this.masterStates, this.props, finalizedLocation);
                this.onCompletionPromise.complete(completed);
                PendingCheckpointStats statsCallback = this.statsCallback;
                if (statsCallback != null) {
                    CompletedCheckpointStats.DiscardCallback discardCallback = statsCallback.reportCompletedCheckpoint(finalizedLocation.getExternalPointer());
                    completed.setDiscardCallback(discardCallback);
                }
                this.dispose(false);
                return completed;
            }
            catch (Throwable t) {
                this.onCompletionPromise.completeExceptionally(t);
                ExceptionUtils.rethrowIOException((Throwable)t);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAcknowledgeResult acknowledgeTask(ExecutionAttemptID executionAttemptId, TaskStateSnapshot operatorSubtaskStates, CheckpointMetrics metrics) {
        Object object = this.lock;
        synchronized (object) {
            if (this.discarded) {
                return TaskAcknowledgeResult.DISCARDED;
            }
            ExecutionVertex vertex = this.notYetAcknowledgedTasks.remove((Object)executionAttemptId);
            if (vertex == null) {
                if (this.acknowledgedTasks.contains((Object)executionAttemptId)) {
                    return TaskAcknowledgeResult.DUPLICATE;
                }
                return TaskAcknowledgeResult.UNKNOWN;
            }
            this.acknowledgedTasks.add(executionAttemptId);
            List<OperatorIDPair> operatorIDs = vertex.getJobVertex().getOperatorIDs();
            int subtaskIndex = vertex.getParallelSubtaskIndex();
            long ackTimestamp = System.currentTimeMillis();
            long stateSize = 0L;
            if (operatorSubtaskStates != null) {
                for (OperatorIDPair operatorID : operatorIDs) {
                    OperatorState operatorState;
                    OperatorSubtaskState operatorSubtaskState = operatorSubtaskStates.getSubtaskStateByOperatorID(operatorID.getGeneratedOperatorID());
                    if (operatorSubtaskState == null) {
                        operatorSubtaskState = new OperatorSubtaskState();
                    }
                    if ((operatorState = this.operatorStates.get((Object)operatorID.getGeneratedOperatorID())) == null) {
                        operatorState = new OperatorState(operatorID.getGeneratedOperatorID(), vertex.getTotalNumberOfParallelSubtasks(), vertex.getMaxParallelism());
                        this.operatorStates.put(operatorID.getGeneratedOperatorID(), operatorState);
                    }
                    operatorState.putState(subtaskIndex, operatorSubtaskState);
                    stateSize += operatorSubtaskState.getStateSize();
                }
            }
            ++this.numAcknowledgedTasks;
            PendingCheckpointStats statsCallback = this.statsCallback;
            if (statsCallback != null) {
                long alignmentDurationMillis = metrics.getAlignmentDurationNanos() / 1000000L;
                long checkpointStartDelayMillis = metrics.getCheckpointStartDelayNanos() / 1000000L;
                SubtaskStateStats subtaskStateStats = new SubtaskStateStats(subtaskIndex, ackTimestamp, stateSize, metrics.getSyncDurationMillis(), metrics.getAsyncDurationMillis(), alignmentDurationMillis, checkpointStartDelayMillis);
                statsCallback.reportSubtaskStats(vertex.getJobvertexId(), subtaskStateStats);
            }
            return TaskAcknowledgeResult.SUCCESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAcknowledgeResult acknowledgeCoordinatorState(OperatorInfo coordinatorInfo, @Nullable ByteStreamStateHandle stateHandle) {
        Object object = this.lock;
        synchronized (object) {
            if (this.discarded) {
                return TaskAcknowledgeResult.DISCARDED;
            }
            OperatorID operatorId = coordinatorInfo.operatorId();
            OperatorState operatorState = this.operatorStates.get((Object)operatorId);
            if (!this.notYetAcknowledgedOperatorCoordinators.remove((Object)operatorId)) {
                return operatorState != null && operatorState.getCoordinatorState() != null ? TaskAcknowledgeResult.DUPLICATE : TaskAcknowledgeResult.UNKNOWN;
            }
            if (stateHandle != null) {
                if (operatorState == null) {
                    operatorState = new OperatorState(operatorId, coordinatorInfo.currentParallelism(), coordinatorInfo.maxParallelism());
                    this.operatorStates.put(operatorId, operatorState);
                }
                operatorState.setCoordinatorState(stateHandle);
            }
            return TaskAcknowledgeResult.SUCCESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeMasterState(String identifier, @Nullable MasterState state) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.discarded && this.notYetAcknowledgedMasterStates.remove(identifier) && state != null) {
                this.masterStates.add(state);
            }
        }
    }

    public void abort(CheckpointFailureReason reason, @Nullable Throwable cause) {
        try {
            this.failureCause = new CheckpointException(reason, cause);
            this.onCompletionPromise.completeExceptionally(this.failureCause);
            this.reportFailedCheckpoint(this.failureCause);
            this.assertAbortSubsumedForced(reason);
        }
        finally {
            this.dispose(true);
        }
    }

    public void abort(CheckpointFailureReason reason) {
        this.abort(reason, null);
    }

    private void assertAbortSubsumedForced(CheckpointFailureReason reason) {
        if (this.props.isSavepoint() && reason == CheckpointFailureReason.CHECKPOINT_SUBSUMED) {
            throw new IllegalStateException("Bug: savepoints must never be subsumed, the abort reason is : " + reason.message());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean releaseState) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.numAcknowledgedTasks = -1;
                if (!this.discarded && releaseState) {
                    this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                StateUtil.bestEffortDiscardAllStateObjects(PendingCheckpoint.this.operatorStates.values());
                                PendingCheckpoint.this.targetLocation.disposeOnFailure();
                            }
                            catch (Throwable t) {
                                LOG.warn("Could not properly dispose the private states in the pending checkpoint {} of job {}.", new Object[]{PendingCheckpoint.this.checkpointId, PendingCheckpoint.this.jobId, t});
                            }
                            finally {
                                PendingCheckpoint.this.operatorStates.clear();
                            }
                        }
                    });
                }
            }
            finally {
                this.discarded = true;
                this.notYetAcknowledgedTasks.clear();
                this.acknowledgedTasks.clear();
                this.cancelCanceller();
            }
        }
    }

    private void cancelCanceller() {
        try {
            ScheduledFuture<?> canceller = this.cancellerHandle;
            if (canceller != null) {
                canceller.cancel(false);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while cancelling checkpoint timeout task", (Throwable)e);
        }
    }

    private void reportFailedCheckpoint(Exception cause) {
        PendingCheckpointStats statsCallback = this.statsCallback;
        if (statsCallback != null) {
            long failureTimestamp = System.currentTimeMillis();
            statsCallback.reportFailedCheckpoint(failureTimestamp, cause);
        }
    }

    public String toString() {
        return String.format("Pending Checkpoint %d @ %d - confirmed=%d, pending=%d", this.checkpointId, this.checkpointTimestamp, this.getNumberOfAcknowledgedTasks(), this.getNumberOfNonAcknowledgedTasks());
    }

    public static enum TaskAcknowledgeResult {
        SUCCESS,
        DUPLICATE,
        UNKNOWN,
        DISCARDED;

    }
}

