/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class PendingCheckpointStats
extends AbstractCheckpointStats {
    private static final long serialVersionUID = -973959257699390327L;
    private final transient CheckpointStatsTracker.PendingCheckpointStatsCallback trackerCallback;
    private volatile int currentNumAcknowledgedSubtasks;
    private volatile long currentStateSize;
    private volatile SubtaskStateStats latestAcknowledgedSubtask;

    PendingCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props2, int totalSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats, CheckpointStatsTracker.PendingCheckpointStatsCallback trackerCallback) {
        super(checkpointId, triggerTimestamp, props2, totalSubtaskCount, taskStats);
        this.trackerCallback = (CheckpointStatsTracker.PendingCheckpointStatsCallback)Preconditions.checkNotNull((Object)trackerCallback);
    }

    @Override
    public CheckpointStatsStatus getStatus() {
        return CheckpointStatsStatus.IN_PROGRESS;
    }

    @Override
    public int getNumberOfAcknowledgedSubtasks() {
        return this.currentNumAcknowledgedSubtasks;
    }

    @Override
    public long getStateSize() {
        return this.currentStateSize;
    }

    @Override
    public SubtaskStateStats getLatestAcknowledgedSubtaskStats() {
        return this.latestAcknowledgedSubtask;
    }

    boolean reportSubtaskStats(JobVertexID jobVertexId, SubtaskStateStats subtask) {
        TaskStateStats taskStateStats = (TaskStateStats)this.taskStats.get(jobVertexId);
        if (taskStateStats != null && taskStateStats.reportSubtaskStats(subtask)) {
            ++this.currentNumAcknowledgedSubtasks;
            this.latestAcknowledgedSubtask = subtask;
            this.currentStateSize += subtask.getStateSize();
            return true;
        }
        return false;
    }

    CompletedCheckpointStats.DiscardCallback reportCompletedCheckpoint(String externalPointer) {
        CompletedCheckpointStats completed = new CompletedCheckpointStats(this.checkpointId, this.triggerTimestamp, this.props, this.numberOfSubtasks, new HashMap<JobVertexID, TaskStateStats>(this.taskStats), this.currentNumAcknowledgedSubtasks, this.currentStateSize, this.latestAcknowledgedSubtask, externalPointer);
        this.trackerCallback.reportCompletedCheckpoint(completed);
        return completed.getDiscardCallback();
    }

    void reportFailedCheckpoint(long failureTimestamp, @Nullable Throwable cause) {
        FailedCheckpointStats failed = new FailedCheckpointStats(this.checkpointId, this.triggerTimestamp, this.props, this.numberOfSubtasks, new HashMap<JobVertexID, TaskStateStats>(this.taskStats), this.currentNumAcknowledgedSubtasks, this.currentStateSize, failureTimestamp, this.latestAcknowledgedSubtask, cause);
        this.trackerCallback.reportFailedCheckpoint(failed);
    }

    public String toString() {
        return "PendingCheckpoint(id=" + this.getCheckpointId() + ")";
    }
}

