/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.config.memory.CommonProcessMemorySpec;
import org.apache.flink.runtime.util.config.memory.JvmMetaspaceAndOverhead;
import org.apache.flink.runtime.util.config.memory.taskmanager.TaskExecutorFlinkMemory;

public class TaskExecutorProcessSpec
extends CommonProcessMemorySpec<TaskExecutorFlinkMemory> {
    private static final long serialVersionUID = 1L;
    private final CPUResource cpuCores;

    @VisibleForTesting
    public TaskExecutorProcessSpec(CPUResource cpuCores, MemorySize frameworkHeapSize, MemorySize frameworkOffHeapSize, MemorySize taskHeapSize, MemorySize taskOffHeapSize, MemorySize networkMemSize, MemorySize managedMemorySize, MemorySize jvmMetaspaceSize, MemorySize jvmOverheadSize) {
        this(cpuCores, new TaskExecutorFlinkMemory(frameworkHeapSize, frameworkOffHeapSize, taskHeapSize, taskOffHeapSize, networkMemSize, managedMemorySize), new JvmMetaspaceAndOverhead(jvmMetaspaceSize, jvmOverheadSize));
    }

    protected TaskExecutorProcessSpec(CPUResource cpuCores, TaskExecutorFlinkMemory flinkMemory, JvmMetaspaceAndOverhead jvmMetaspaceAndOverhead) {
        super(flinkMemory, jvmMetaspaceAndOverhead);
        this.cpuCores = cpuCores;
    }

    public CPUResource getCpuCores() {
        return this.cpuCores;
    }

    MemorySize getFrameworkHeapSize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getFrameworkHeap();
    }

    MemorySize getFrameworkOffHeapMemorySize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getFrameworkOffHeap();
    }

    public MemorySize getTaskHeapSize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getTaskHeap();
    }

    public MemorySize getTaskOffHeapSize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getTaskOffHeap();
    }

    public MemorySize getNetworkMemSize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getNetwork();
    }

    public MemorySize getManagedMemorySize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getManaged();
    }

    public String toString() {
        return "TaskExecutorProcessSpec {cpuCores=" + this.cpuCores.getValue().doubleValue() + ", frameworkHeapSize=" + this.getFrameworkHeapSize().toHumanReadableString() + ", frameworkOffHeapSize=" + this.getFrameworkOffHeapMemorySize().toHumanReadableString() + ", taskHeapSize=" + this.getTaskHeapSize().toHumanReadableString() + ", taskOffHeapSize=" + this.getTaskOffHeapSize().toHumanReadableString() + ", networkMemSize=" + this.getNetworkMemSize().toHumanReadableString() + ", managedMemorySize=" + this.getManagedMemorySize().toHumanReadableString() + ", jvmMetaspaceSize=" + this.getJvmMetaspaceSize().toHumanReadableString() + ", jvmOverheadSize=" + this.getJvmOverheadSize().toHumanReadableString() + '}';
    }
}

