/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.apache.flink.util.Preconditions;

public class ExecutionGraphRestartCallback
implements RestartCallback {
    private final ExecutionGraph execGraph;
    private final AtomicBoolean used;
    private final long expectedGlobalModVersion;

    public ExecutionGraphRestartCallback(ExecutionGraph execGraph, long expectedGlobalModVersion) {
        this.execGraph = (ExecutionGraph)Preconditions.checkNotNull((Object)execGraph);
        this.used = new AtomicBoolean(false);
        this.expectedGlobalModVersion = expectedGlobalModVersion;
    }

    @Override
    public void triggerFullRecovery() {
        if (this.used.compareAndSet(false, true)) {
            this.execGraph.restart(this.expectedGlobalModVersion);
        }
    }
}

