/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureRequestCoordinator;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTracker;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTrackerImpl;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class JobManagerSharedServices {
    private final ScheduledExecutorService scheduledExecutorService;
    private final LibraryCacheManager libraryCacheManager;
    private final BackPressureRequestCoordinator backPressureSampleCoordinator;
    private final BackPressureStatsTracker backPressureStatsTracker;
    @Nonnull
    private final BlobWriter blobWriter;

    public JobManagerSharedServices(ScheduledExecutorService scheduledExecutorService, LibraryCacheManager libraryCacheManager, BackPressureRequestCoordinator backPressureSampleCoordinator, BackPressureStatsTracker backPressureStatsTracker, @Nonnull BlobWriter blobWriter) {
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService);
        this.libraryCacheManager = (LibraryCacheManager)Preconditions.checkNotNull((Object)libraryCacheManager);
        this.backPressureSampleCoordinator = (BackPressureRequestCoordinator)Preconditions.checkNotNull((Object)backPressureSampleCoordinator);
        this.backPressureStatsTracker = (BackPressureStatsTracker)Preconditions.checkNotNull((Object)backPressureStatsTracker);
        this.blobWriter = blobWriter;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public LibraryCacheManager getLibraryCacheManager() {
        return this.libraryCacheManager;
    }

    public BackPressureStatsTracker getBackPressureStatsTracker() {
        return this.backPressureStatsTracker;
    }

    @Nonnull
    public BlobWriter getBlobWriter() {
        return this.blobWriter;
    }

    public void shutdown() throws Exception {
        Throwable firstException = null;
        try {
            this.scheduledExecutorService.shutdownNow();
        }
        catch (Throwable t) {
            firstException = t;
        }
        this.libraryCacheManager.shutdown();
        this.backPressureSampleCoordinator.shutDown();
        this.backPressureStatsTracker.shutDown();
        if (firstException != null) {
            ExceptionUtils.rethrowException((Throwable)firstException, (String)"Error while shutting down JobManager services");
        }
    }

    public static JobManagerSharedServices fromConfiguration(Configuration config, BlobServer blobServer, FatalErrorHandler fatalErrorHandler) {
        Duration akkaTimeout;
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)blobServer);
        String classLoaderResolveOrder = config.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns((Configuration)config);
        boolean failOnJvmMetaspaceOomError = config.getBoolean(CoreOptions.FAIL_ON_USER_CLASS_LOADING_METASPACE_OOM);
        BlobLibraryCacheManager libraryCacheManager = new BlobLibraryCacheManager(blobServer, BlobLibraryCacheManager.defaultClassLoaderFactory(FlinkUserCodeClassLoaders.ResolveOrder.fromString(classLoaderResolveOrder), alwaysParentFirstLoaderPatterns, failOnJvmMetaspaceOomError ? fatalErrorHandler : null));
        try {
            akkaTimeout = AkkaUtils.getTimeout(config);
        }
        catch (NumberFormatException e) {
            throw new IllegalConfigurationException(AkkaUtils.formatDurationParsingErrorMessage());
        }
        ScheduledExecutorService futureExecutor = Executors.newScheduledThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("jobmanager-future"));
        int numSamples = config.getInteger(WebOptions.BACKPRESSURE_NUM_SAMPLES);
        long delayBetweenSamples = config.getInteger(WebOptions.BACKPRESSURE_DELAY);
        BackPressureRequestCoordinator coordinator = new BackPressureRequestCoordinator(futureExecutor, akkaTimeout.toMillis() + (long)numSamples * delayBetweenSamples);
        int cleanUpInterval = config.getInteger(WebOptions.BACKPRESSURE_CLEANUP_INTERVAL);
        BackPressureStatsTrackerImpl backPressureStatsTracker = new BackPressureStatsTrackerImpl(coordinator, cleanUpInterval, config.getInteger(WebOptions.BACKPRESSURE_REFRESH_INTERVAL));
        futureExecutor.scheduleWithFixedDelay(backPressureStatsTracker::cleanUpOperatorStatsCache, cleanUpInterval, cleanUpInterval, TimeUnit.MILLISECONDS);
        return new JobManagerSharedServices(futureExecutor, libraryCacheManager, coordinator, backPressureStatsTracker, blobServer);
    }
}

