/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;

@ThreadSafe
public class SystemResourcesCounter
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(SystemResourcesCounter.class);
    private final long probeIntervalMs;
    private final SystemInfo systemInfo = new SystemInfo();
    private final HardwareAbstractionLayer hardwareAbstractionLayer = this.systemInfo.getHardware();
    private volatile boolean running = true;
    private long[] previousCpuTicks;
    private long[] bytesReceivedPerInterface;
    private long[] bytesSentPerInterface;
    private volatile double cpuUser;
    private volatile double cpuNice;
    private volatile double cpuSys;
    private volatile double cpuIdle;
    private volatile double cpuIOWait;
    private volatile double cpuIrq;
    private volatile double cpuSoftIrq;
    private volatile double cpuUsage;
    private volatile double cpuLoad1;
    private volatile double cpuLoad5;
    private volatile double cpuLoad15;
    private AtomicReferenceArray<Double> cpuUsagePerProcessor;
    private final String[] networkInterfaceNames;
    private AtomicLongArray receiveRatePerInterface;
    private AtomicLongArray sendRatePerInterface;

    public SystemResourcesCounter(Time probeInterval) {
        this.probeIntervalMs = probeInterval.toMilliseconds();
        Preconditions.checkState((this.probeIntervalMs > 0L ? 1 : 0) != 0);
        this.setName(SystemResourcesCounter.class.getSimpleName() + " probing thread");
        this.cpuUsagePerProcessor = new AtomicReferenceArray(this.hardwareAbstractionLayer.getProcessor().getLogicalProcessorCount());
        NetworkIF[] networkIFs = this.hardwareAbstractionLayer.getNetworkIFs();
        this.bytesReceivedPerInterface = new long[networkIFs.length];
        this.bytesSentPerInterface = new long[networkIFs.length];
        this.receiveRatePerInterface = new AtomicLongArray(networkIFs.length);
        this.sendRatePerInterface = new AtomicLongArray(networkIFs.length);
        this.networkInterfaceNames = new String[networkIFs.length];
        for (int i = 0; i < this.networkInterfaceNames.length; ++i) {
            this.networkInterfaceNames[i] = networkIFs[i].getName();
        }
    }

    @Override
    public void run() {
        block3: {
            try {
                while (this.running) {
                    this.calculateCPUUsage(this.hardwareAbstractionLayer.getProcessor());
                    this.calculateNetworkUsage(this.hardwareAbstractionLayer.getNetworkIFs());
                    Thread.sleep(this.probeIntervalMs);
                }
            }
            catch (InterruptedException e) {
                if (!this.running) break block3;
                LOG.warn("{} has failed", (Object)SystemResourcesCounter.class.getSimpleName(), (Object)e);
            }
        }
    }

    public void shutdown() throws InterruptedException {
        this.running = false;
        this.interrupt();
        this.join();
    }

    public double getCpuUser() {
        return this.cpuUser;
    }

    public double getCpuNice() {
        return this.cpuNice;
    }

    public double getCpuSys() {
        return this.cpuSys;
    }

    public double getCpuIdle() {
        return this.cpuIdle;
    }

    public double getIOWait() {
        return this.cpuIOWait;
    }

    public double getCpuIrq() {
        return this.cpuIrq;
    }

    public double getCpuSoftIrq() {
        return this.cpuSoftIrq;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public double getCpuLoad1() {
        return this.cpuLoad1;
    }

    public double getCpuLoad5() {
        return this.cpuLoad5;
    }

    public double getCpuLoad15() {
        return this.cpuLoad15;
    }

    public int getProcessorsCount() {
        return this.cpuUsagePerProcessor.length();
    }

    public double getCpuUsagePerProcessor(int processor) {
        return this.cpuUsagePerProcessor.get(processor);
    }

    public String[] getNetworkInterfaceNames() {
        return this.networkInterfaceNames;
    }

    public long getReceiveRatePerInterface(int interfaceNo) {
        return this.receiveRatePerInterface.get(interfaceNo);
    }

    public long getSendRatePerInterface(int interfaceNo) {
        return this.sendRatePerInterface.get(interfaceNo);
    }

    private void calculateCPUUsage(CentralProcessor processor) {
        long[] ticks = processor.getSystemCpuLoadTicks();
        if (this.previousCpuTicks == null) {
            this.previousCpuTicks = ticks;
        }
        long userTicks = ticks[CentralProcessor.TickType.USER.getIndex()] - this.previousCpuTicks[CentralProcessor.TickType.USER.getIndex()];
        long niceTicks = ticks[CentralProcessor.TickType.NICE.getIndex()] - this.previousCpuTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sysTicks = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - this.previousCpuTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idleTicks = ticks[CentralProcessor.TickType.IDLE.getIndex()] - this.previousCpuTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowaitTicks = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - this.previousCpuTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irqTicks = ticks[CentralProcessor.TickType.IRQ.getIndex()] - this.previousCpuTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softIrqTicks = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - this.previousCpuTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long totalCpuTicks = userTicks + niceTicks + sysTicks + idleTicks + iowaitTicks + irqTicks + softIrqTicks;
        this.previousCpuTicks = ticks;
        this.cpuUser = 100.0 * (double)userTicks / (double)totalCpuTicks;
        this.cpuNice = 100.0 * (double)niceTicks / (double)totalCpuTicks;
        this.cpuSys = 100.0 * (double)sysTicks / (double)totalCpuTicks;
        this.cpuIdle = 100.0 * (double)idleTicks / (double)totalCpuTicks;
        this.cpuIOWait = 100.0 * (double)iowaitTicks / (double)totalCpuTicks;
        this.cpuIrq = 100.0 * (double)irqTicks / (double)totalCpuTicks;
        this.cpuSoftIrq = 100.0 * (double)softIrqTicks / (double)totalCpuTicks;
        this.cpuUsage = processor.getSystemCpuLoad() * 100.0;
        double[] loadAverage = processor.getSystemLoadAverage(3);
        this.cpuLoad1 = loadAverage[0] < 0.0 ? Double.NaN : loadAverage[0];
        this.cpuLoad5 = loadAverage[1] < 0.0 ? Double.NaN : loadAverage[1];
        this.cpuLoad15 = loadAverage[2] < 0.0 ? Double.NaN : loadAverage[2];
        double[] load2 = processor.getProcessorCpuLoadBetweenTicks();
        Preconditions.checkState((load2.length == this.cpuUsagePerProcessor.length() ? 1 : 0) != 0);
        for (int i = 0; i < load2.length; ++i) {
            this.cpuUsagePerProcessor.set(i, load2[i] * 100.0);
        }
    }

    private void calculateNetworkUsage(NetworkIF[] networkIFs) {
        Preconditions.checkState((networkIFs.length == this.receiveRatePerInterface.length() ? 1 : 0) != 0);
        for (int i = 0; i < networkIFs.length; ++i) {
            NetworkIF networkIF = networkIFs[i];
            networkIF.updateNetworkStats();
            this.receiveRatePerInterface.set(i, (networkIF.getBytesRecv() - this.bytesReceivedPerInterface[i]) * 1000L / this.probeIntervalMs);
            this.sendRatePerInterface.set(i, (networkIF.getBytesSent() - this.bytesSentPerInterface[i]) * 1000L / this.probeIntervalMs);
            this.bytesReceivedPerInterface[i] = networkIF.getBytesRecv();
            this.bytesSentPerInterface[i] = networkIF.getBytesSent();
        }
    }
}

