/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.sort.FixedLengthRecordSorter;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.InMemorySorterFactory;
import org.apache.flink.runtime.operators.sort.NormalizedKeySorter;

public class DefaultInMemorySorterFactory<T>
implements InMemorySorterFactory<T> {
    @Nonnull
    private final TypeSerializerFactory<T> typeSerializerFactory;
    @Nonnull
    private final TypeComparator<T> typeComparator;
    private final boolean useFixedLengthRecordSorter;

    DefaultInMemorySorterFactory(@Nonnull TypeSerializerFactory<T> typeSerializerFactory, @Nonnull TypeComparator<T> typeComparator, int thresholdForInPlaceSorting) {
        this.typeSerializerFactory = typeSerializerFactory;
        this.typeComparator = typeComparator;
        TypeSerializer typeSerializer = typeSerializerFactory.getSerializer();
        this.useFixedLengthRecordSorter = typeComparator.supportsSerializationWithKeyNormalization() && typeSerializer.getLength() > 0 && typeSerializer.getLength() <= thresholdForInPlaceSorting;
    }

    @Override
    public InMemorySorter<T> create(List<MemorySegment> sortSegments) {
        TypeSerializer typeSerializer = this.typeSerializerFactory.getSerializer();
        TypeComparator duplicateTypeComparator = this.typeComparator.duplicate();
        if (this.useFixedLengthRecordSorter) {
            return new FixedLengthRecordSorter(typeSerializer, duplicateTypeComparator, sortSegments);
        }
        return new NormalizedKeySorter(typeSerializer, duplicateTypeComparator, sortSegments);
    }
}

