/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.apache.flink.queryablestate.network.stats.KvStateRequestStats;
import org.apache.flink.runtime.query.KvStateClientProxy;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.KvStateServer;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryableStateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(QueryableStateUtils.class);
    private static final String ERROR_MESSAGE_ON_LOAD_FAILURE = "Probable reason: flink-queryable-state-runtime is not in the classpath. To enable Queryable State, please move the flink-queryable-state-runtime jar from the opt to the lib folder.";

    public static KvStateClientProxy createKvStateClientProxy(String address, Iterator<Integer> ports, int eventLoopThreads, int queryThreads, KvStateRequestStats stats) {
        Preconditions.checkNotNull((Object)address, (String)"address");
        Preconditions.checkNotNull((Object)stats, (String)"stats");
        Preconditions.checkArgument((eventLoopThreads >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((queryThreads >= 1 ? 1 : 0) != 0);
        try {
            String classname = "org.apache.flink.queryablestate.client.proxy.KvStateClientProxyImpl";
            Class<KvStateClientProxy> clazz = Class.forName(classname).asSubclass(KvStateClientProxy.class);
            Constructor<KvStateClientProxy> constructor = clazz.getConstructor(String.class, Iterator.class, Integer.class, Integer.class, KvStateRequestStats.class);
            return constructor.newInstance(address, ports, eventLoopThreads, queryThreads, stats);
        }
        catch (ClassNotFoundException e) {
            String msg = "Could not load Queryable State Client Proxy. Probable reason: flink-queryable-state-runtime is not in the classpath. To enable Queryable State, please move the flink-queryable-state-runtime jar from the opt to the lib folder.";
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not load Queryable State Client Proxy. Probable reason: flink-queryable-state-runtime is not in the classpath. To enable Queryable State, please move the flink-queryable-state-runtime jar from the opt to the lib folder. Cause: " + e.getMessage());
            } else {
                LOG.info("Could not load Queryable State Client Proxy. Probable reason: flink-queryable-state-runtime is not in the classpath. To enable Queryable State, please move the flink-queryable-state-runtime jar from the opt to the lib folder.");
            }
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error("Queryable State Client Proxy could not be created: ", e.getTargetException());
            return null;
        }
        catch (Throwable t) {
            LOG.error("Failed to instantiate the Queryable State Client Proxy.", t);
            return null;
        }
    }

    public static KvStateServer createKvStateServer(String address, Iterator<Integer> ports, int eventLoopThreads, int queryThreads, KvStateRegistry kvStateRegistry, KvStateRequestStats stats) {
        Preconditions.checkNotNull((Object)address, (String)"address");
        Preconditions.checkNotNull((Object)kvStateRegistry, (String)"registry");
        Preconditions.checkNotNull((Object)stats, (String)"stats");
        Preconditions.checkArgument((eventLoopThreads >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((queryThreads >= 1 ? 1 : 0) != 0);
        try {
            String classname = "org.apache.flink.queryablestate.server.KvStateServerImpl";
            Class<KvStateServer> clazz = Class.forName(classname).asSubclass(KvStateServer.class);
            Constructor<KvStateServer> constructor = clazz.getConstructor(String.class, Iterator.class, Integer.class, Integer.class, KvStateRegistry.class, KvStateRequestStats.class);
            return constructor.newInstance(address, ports, eventLoopThreads, queryThreads, kvStateRegistry, stats);
        }
        catch (ClassNotFoundException e) {
            String msg = "Could not load Queryable State Server. Probable reason: flink-queryable-state-runtime is not in the classpath. To enable Queryable State, please move the flink-queryable-state-runtime jar from the opt to the lib folder.";
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not load Queryable State Server. Probable reason: flink-queryable-state-runtime is not in the classpath. To enable Queryable State, please move the flink-queryable-state-runtime jar from the opt to the lib folder. Cause: " + e.getMessage());
            } else {
                LOG.info("Could not load Queryable State Server. Probable reason: flink-queryable-state-runtime is not in the classpath. To enable Queryable State, please move the flink-queryable-state-runtime jar from the opt to the lib folder.");
            }
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error("Queryable State Server could not be created: ", e.getTargetException());
            return null;
        }
        catch (Throwable t) {
            LOG.error("Failed to instantiate the Queryable State Server.", t);
            return null;
        }
    }
}

