/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.ConfigurationException;

public abstract class ResourceManagerFactory<T extends ResourceIDRetrievable> {
    public ResourceManager<T> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, MetricRegistry metricRegistry, String hostname) throws Exception {
        ResourceManagerMetricGroup resourceManagerMetricGroup = ResourceManagerMetricGroup.create(metricRegistry, hostname);
        SlotManagerMetricGroup slotManagerMetricGroup = SlotManagerMetricGroup.create(metricRegistry, hostname);
        ResourceManagerRuntimeServices resourceManagerRuntimeServices = this.createResourceManagerRuntimeServices(configuration, rpcService, highAvailabilityServices, slotManagerMetricGroup);
        return this.createResourceManager(configuration, resourceId, rpcService, highAvailabilityServices, heartbeatServices, fatalErrorHandler, clusterInformation, webInterfaceUrl, resourceManagerMetricGroup, resourceManagerRuntimeServices);
    }

    protected abstract ResourceManager<T> createResourceManager(Configuration var1, ResourceID var2, RpcService var3, HighAvailabilityServices var4, HeartbeatServices var5, FatalErrorHandler var6, ClusterInformation var7, @Nullable String var8, ResourceManagerMetricGroup var9, ResourceManagerRuntimeServices var10) throws Exception;

    private ResourceManagerRuntimeServices createResourceManagerRuntimeServices(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, SlotManagerMetricGroup slotManagerMetricGroup) throws ConfigurationException {
        return ResourceManagerRuntimeServices.fromConfiguration(this.createResourceManagerRuntimeServicesConfiguration(configuration), highAvailabilityServices, rpcService.getScheduledExecutor(), slotManagerMetricGroup);
    }

    protected abstract ResourceManagerRuntimeServicesConfiguration createResourceManagerRuntimeServicesConfiguration(Configuration var1) throws ConfigurationException;
}

