/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerSlot;
import org.apache.flink.util.Preconditions;

public class PendingSlotRequest {
    private final SlotRequest slotRequest;
    @Nullable
    private CompletableFuture<Acknowledge> requestFuture;
    @Nullable
    private PendingTaskManagerSlot pendingTaskManagerSlot;
    private final long creationTimestamp;

    public PendingSlotRequest(SlotRequest slotRequest) {
        this.slotRequest = (SlotRequest)Preconditions.checkNotNull((Object)slotRequest);
        this.requestFuture = null;
        this.pendingTaskManagerSlot = null;
        this.creationTimestamp = System.currentTimeMillis();
    }

    public AllocationID getAllocationId() {
        return this.slotRequest.getAllocationId();
    }

    public ResourceProfile getResourceProfile() {
        return this.slotRequest.getResourceProfile();
    }

    public JobID getJobId() {
        return this.slotRequest.getJobId();
    }

    public String getTargetAddress() {
        return this.slotRequest.getTargetAddress();
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public boolean isAssigned() {
        return null != this.requestFuture;
    }

    public void setRequestFuture(@Nullable CompletableFuture<Acknowledge> requestFuture) {
        this.requestFuture = requestFuture;
    }

    @Nullable
    public CompletableFuture<Acknowledge> getRequestFuture() {
        return this.requestFuture;
    }

    @Nullable
    public PendingTaskManagerSlot getAssignedPendingTaskManagerSlot() {
        return this.pendingTaskManagerSlot;
    }

    public void assignPendingTaskManagerSlot(@Nonnull PendingTaskManagerSlot pendingTaskManagerSlotToAssign) {
        Preconditions.checkState((this.pendingTaskManagerSlot == null ? 1 : 0) != 0);
        this.pendingTaskManagerSlot = pendingTaskManagerSlotToAssign;
    }

    public void unassignPendingTaskManagerSlot() {
        this.pendingTaskManagerSlot = null;
    }
}

