/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.failover.flip1.ExecutionFailureHandler;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureHandlingResult;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.restart.ThrowingRestartStrategy;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.ThrowingSlotProvider;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTracker;
import org.apache.flink.runtime.scheduler.DeploymentHandle;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocator;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.ExecutionVertexOperations;
import org.apache.flink.runtime.scheduler.ExecutionVertexSchedulingRequirementsMapper;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersion;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersioner;
import org.apache.flink.runtime.scheduler.SchedulerBase;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.SlotExecutionVertexAssignment;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyFactory;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class DefaultScheduler
extends SchedulerBase
implements SchedulerOperations {
    private final Logger log;
    private final ClassLoader userCodeLoader;
    private final ExecutionSlotAllocator executionSlotAllocator;
    private final ExecutionFailureHandler executionFailureHandler;
    private final ScheduledExecutor delayExecutor;
    private final SchedulingStrategy schedulingStrategy;
    private final ExecutionVertexOperations executionVertexOperations;
    private final Set<ExecutionVertexID> verticesWaitingForRestart;

    DefaultScheduler(Logger log, JobGraph jobGraph, BackPressureStatsTracker backPressureStatsTracker, Executor ioExecutor, Configuration jobMasterConfiguration, ScheduledExecutorService futureExecutor, ScheduledExecutor delayExecutor, ClassLoader userCodeLoader, CheckpointRecoveryFactory checkpointRecoveryFactory, Time rpcTimeout, BlobWriter blobWriter, JobManagerJobMetricGroup jobManagerJobMetricGroup, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker, SchedulingStrategyFactory schedulingStrategyFactory, FailoverStrategy.Factory failoverStrategyFactory, RestartBackoffTimeStrategy restartBackoffTimeStrategy, ExecutionVertexOperations executionVertexOperations, ExecutionVertexVersioner executionVertexVersioner, ExecutionSlotAllocatorFactory executionSlotAllocatorFactory) throws Exception {
        super(log, jobGraph, backPressureStatsTracker, ioExecutor, jobMasterConfiguration, new ThrowingSlotProvider(), futureExecutor, userCodeLoader, checkpointRecoveryFactory, rpcTimeout, new ThrowingRestartStrategy.ThrowingRestartStrategyFactory(), blobWriter, jobManagerJobMetricGroup, Time.seconds((long)0L), shuffleMaster, partitionTracker, executionVertexVersioner, false);
        this.log = log;
        this.delayExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)delayExecutor);
        this.userCodeLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeLoader);
        this.executionVertexOperations = (ExecutionVertexOperations)Preconditions.checkNotNull((Object)executionVertexOperations);
        FailoverStrategy failoverStrategy = failoverStrategyFactory.create(this.getSchedulingTopology(), this.getResultPartitionAvailabilityChecker());
        log.info("Using failover strategy {} for {} ({}).", new Object[]{failoverStrategy, jobGraph.getName(), jobGraph.getJobID()});
        this.executionFailureHandler = new ExecutionFailureHandler(this.getSchedulingTopology(), failoverStrategy, restartBackoffTimeStrategy);
        this.schedulingStrategy = schedulingStrategyFactory.createInstance(this, this.getSchedulingTopology());
        this.executionSlotAllocator = ((ExecutionSlotAllocatorFactory)Preconditions.checkNotNull((Object)executionSlotAllocatorFactory)).createInstance(this.getInputsLocationsRetriever());
        this.verticesWaitingForRestart = new HashSet<ExecutionVertexID>();
    }

    @Override
    protected long getNumberOfRestarts() {
        return this.executionFailureHandler.getNumberOfRestarts();
    }

    @Override
    protected void startSchedulingInternal() {
        this.log.info("Starting scheduling with scheduling strategy [{}]", (Object)this.schedulingStrategy.getClass().getName());
        this.prepareExecutionGraphForNgScheduling();
        this.schedulingStrategy.startScheduling();
    }

    @Override
    protected void updateTaskExecutionStateInternal(ExecutionVertexID executionVertexId, TaskExecutionState taskExecutionState) {
        this.schedulingStrategy.onExecutionStateChange(executionVertexId, taskExecutionState.getExecutionState());
        this.maybeHandleTaskFailure(taskExecutionState, executionVertexId);
    }

    private void maybeHandleTaskFailure(TaskExecutionState taskExecutionState, ExecutionVertexID executionVertexId) {
        if (taskExecutionState.getExecutionState() == ExecutionState.FAILED) {
            Throwable error = taskExecutionState.getError(this.userCodeLoader);
            this.handleTaskFailure(executionVertexId, error);
        }
    }

    private void handleTaskFailure(ExecutionVertexID executionVertexId, @Nullable Throwable error) {
        this.setGlobalFailureCause(error);
        this.notifyCoordinatorsAboutTaskFailure(executionVertexId, error);
        FailureHandlingResult failureHandlingResult = this.executionFailureHandler.getFailureHandlingResult(executionVertexId, error);
        this.maybeRestartTasks(failureHandlingResult);
    }

    private void notifyCoordinatorsAboutTaskFailure(ExecutionVertexID executionVertexId, @Nullable Throwable error) {
        ExecutionJobVertex jobVertex = this.getExecutionJobVertex(executionVertexId.getJobVertexId());
        int subtaskIndex = executionVertexId.getSubtaskIndex();
        jobVertex.getOperatorCoordinators().forEach(c -> c.subtaskFailed(subtaskIndex, error));
    }

    @Override
    public void handleGlobalFailure(Throwable error) {
        this.setGlobalFailureCause(error);
        this.log.info("Trying to recover from a global failure.", error);
        FailureHandlingResult failureHandlingResult = this.executionFailureHandler.getGlobalFailureHandlingResult(error);
        this.maybeRestartTasks(failureHandlingResult);
    }

    private void maybeRestartTasks(FailureHandlingResult failureHandlingResult) {
        if (failureHandlingResult.canRestart()) {
            this.restartTasksWithDelay(failureHandlingResult);
        } else {
            this.failJob(failureHandlingResult.getError());
        }
    }

    private void restartTasksWithDelay(FailureHandlingResult failureHandlingResult) {
        Set<ExecutionVertexID> verticesToRestart = failureHandlingResult.getVerticesToRestart();
        HashSet<ExecutionVertexVersion> executionVertexVersions = new HashSet<ExecutionVertexVersion>(this.executionVertexVersioner.recordVertexModifications(verticesToRestart).values());
        boolean globalRecovery = failureHandlingResult.isGlobalFailure();
        this.addVerticesToRestartPending(verticesToRestart);
        CompletableFuture<?> cancelFuture = this.cancelTasksAsync(verticesToRestart);
        this.delayExecutor.schedule(() -> FutureUtils.assertNoException(cancelFuture.thenRunAsync(this.restartTasks(executionVertexVersions, globalRecovery), this.getMainThreadExecutor())), failureHandlingResult.getRestartDelayMS(), TimeUnit.MILLISECONDS);
    }

    private void addVerticesToRestartPending(Set<ExecutionVertexID> verticesToRestart) {
        this.verticesWaitingForRestart.addAll(verticesToRestart);
        this.transitionExecutionGraphState(JobStatus.RUNNING, JobStatus.RESTARTING);
    }

    private void removeVerticesFromRestartPending(Set<ExecutionVertexID> verticesToRestart) {
        this.verticesWaitingForRestart.removeAll(verticesToRestart);
        if (this.verticesWaitingForRestart.isEmpty()) {
            this.transitionExecutionGraphState(JobStatus.RESTARTING, JobStatus.RUNNING);
        }
    }

    private Runnable restartTasks(Set<ExecutionVertexVersion> executionVertexVersions, boolean isGlobalRecovery) {
        return () -> {
            Set<ExecutionVertexID> verticesToRestart = this.executionVertexVersioner.getUnmodifiedExecutionVertices(executionVertexVersions);
            this.removeVerticesFromRestartPending(verticesToRestart);
            this.resetForNewExecutions(verticesToRestart);
            try {
                this.restoreState(verticesToRestart, isGlobalRecovery);
            }
            catch (Throwable t) {
                this.handleGlobalFailure(t);
                return;
            }
            this.schedulingStrategy.restartTasks(verticesToRestart);
        };
    }

    private CompletableFuture<?> cancelTasksAsync(Set<ExecutionVertexID> verticesToRestart) {
        List cancelFutures = verticesToRestart.stream().map(this::cancelExecutionVertex).collect(Collectors.toList());
        return FutureUtils.combineAll(cancelFutures);
    }

    private CompletableFuture<?> cancelExecutionVertex(ExecutionVertexID executionVertexId) {
        ExecutionVertex vertex = this.getExecutionVertex(executionVertexId);
        this.notifyCoordinatorOfCancellation(vertex);
        this.executionSlotAllocator.cancel(executionVertexId);
        return this.executionVertexOperations.cancel(vertex);
    }

    @Override
    protected void scheduleOrUpdateConsumersInternal(IntermediateResultPartitionID partitionId) {
        this.schedulingStrategy.onPartitionConsumable(partitionId);
    }

    @Override
    public void allocateSlotsAndDeploy(List<ExecutionVertexDeploymentOption> executionVertexDeploymentOptions) {
        this.validateDeploymentOptions(executionVertexDeploymentOptions);
        Map<ExecutionVertexID, ExecutionVertexDeploymentOption> deploymentOptionsByVertex = DefaultScheduler.groupDeploymentOptionsByVertexId(executionVertexDeploymentOptions);
        List<ExecutionVertexID> verticesToDeploy = executionVertexDeploymentOptions.stream().map(ExecutionVertexDeploymentOption::getExecutionVertexId).collect(Collectors.toList());
        Map<ExecutionVertexID, ExecutionVertexVersion> requiredVersionByVertex = this.executionVertexVersioner.recordVertexModifications(verticesToDeploy);
        this.transitionToScheduled(verticesToDeploy);
        List<SlotExecutionVertexAssignment> slotExecutionVertexAssignments = this.allocateSlots(executionVertexDeploymentOptions);
        List<DeploymentHandle> deploymentHandles = DefaultScheduler.createDeploymentHandles(requiredVersionByVertex, deploymentOptionsByVertex, slotExecutionVertexAssignments);
        this.waitForAllSlotsAndDeploy(deploymentHandles);
    }

    private void validateDeploymentOptions(Collection<ExecutionVertexDeploymentOption> deploymentOptions) {
        deploymentOptions.stream().map(ExecutionVertexDeploymentOption::getExecutionVertexId).map(this::getExecutionVertex).forEach(v -> Preconditions.checkState((v.getExecutionState() == ExecutionState.CREATED ? 1 : 0) != 0, (String)"expected vertex %s to be in CREATED state, was: %s", (Object[])new Object[]{v.getID(), v.getExecutionState()}));
    }

    private static Map<ExecutionVertexID, ExecutionVertexDeploymentOption> groupDeploymentOptionsByVertexId(Collection<ExecutionVertexDeploymentOption> executionVertexDeploymentOptions) {
        return executionVertexDeploymentOptions.stream().collect(Collectors.toMap(ExecutionVertexDeploymentOption::getExecutionVertexId, Function.identity()));
    }

    private List<SlotExecutionVertexAssignment> allocateSlots(List<ExecutionVertexDeploymentOption> executionVertexDeploymentOptions) {
        return this.executionSlotAllocator.allocateSlotsFor(executionVertexDeploymentOptions.stream().map(ExecutionVertexDeploymentOption::getExecutionVertexId).map(this::getExecutionVertex).map(ExecutionVertexSchedulingRequirementsMapper::from).collect(Collectors.toList()));
    }

    private static List<DeploymentHandle> createDeploymentHandles(Map<ExecutionVertexID, ExecutionVertexVersion> requiredVersionByVertex, Map<ExecutionVertexID, ExecutionVertexDeploymentOption> deploymentOptionsByVertex, List<SlotExecutionVertexAssignment> slotExecutionVertexAssignments) {
        return slotExecutionVertexAssignments.stream().map(slotExecutionVertexAssignment -> {
            ExecutionVertexID executionVertexId = slotExecutionVertexAssignment.getExecutionVertexId();
            return new DeploymentHandle((ExecutionVertexVersion)requiredVersionByVertex.get(executionVertexId), (ExecutionVertexDeploymentOption)deploymentOptionsByVertex.get(executionVertexId), (SlotExecutionVertexAssignment)slotExecutionVertexAssignment);
        }).collect(Collectors.toList());
    }

    private void waitForAllSlotsAndDeploy(List<DeploymentHandle> deploymentHandles) {
        FutureUtils.assertNoException(this.assignAllResources(deploymentHandles).handle(this.deployAll(deploymentHandles)));
    }

    private CompletableFuture<Void> assignAllResources(List<DeploymentHandle> deploymentHandles) {
        ArrayList<CompletionStage> slotAssignedFutures = new ArrayList<CompletionStage>();
        for (DeploymentHandle deploymentHandle : deploymentHandles) {
            CompletionStage slotAssigned = deploymentHandle.getSlotExecutionVertexAssignment().getLogicalSlotFuture().handle(this.assignResourceOrHandleError(deploymentHandle));
            slotAssignedFutures.add(slotAssigned);
        }
        return FutureUtils.waitForAll(slotAssignedFutures);
    }

    private BiFunction<Void, Throwable, Void> deployAll(List<DeploymentHandle> deploymentHandles) {
        return (ignored, throwable) -> {
            DefaultScheduler.propagateIfNonNull(throwable);
            for (DeploymentHandle deploymentHandle : deploymentHandles) {
                SlotExecutionVertexAssignment slotExecutionVertexAssignment = deploymentHandle.getSlotExecutionVertexAssignment();
                CompletableFuture<LogicalSlot> slotAssigned = slotExecutionVertexAssignment.getLogicalSlotFuture();
                Preconditions.checkState((boolean)slotAssigned.isDone());
                FutureUtils.assertNoException(slotAssigned.handle(this.deployOrHandleError(deploymentHandle)));
            }
            return null;
        };
    }

    private static void propagateIfNonNull(Throwable throwable) {
        if (throwable != null) {
            throw new CompletionException(throwable);
        }
    }

    private BiFunction<LogicalSlot, Throwable, Void> assignResourceOrHandleError(DeploymentHandle deploymentHandle) {
        ExecutionVertexVersion requiredVertexVersion = deploymentHandle.getRequiredVertexVersion();
        ExecutionVertexID executionVertexId = deploymentHandle.getExecutionVertexId();
        return (logicalSlot, throwable) -> {
            if (this.executionVertexVersioner.isModified(requiredVertexVersion)) {
                this.log.debug("Refusing to assign slot to execution vertex {} because this deployment was superseded by another deployment", (Object)executionVertexId);
                this.releaseSlotIfPresent((LogicalSlot)logicalSlot);
                return null;
            }
            if (throwable == null) {
                ExecutionVertex executionVertex = this.getExecutionVertex(executionVertexId);
                boolean sendScheduleOrUpdateConsumerMessage = deploymentHandle.getDeploymentOption().sendScheduleOrUpdateConsumerMessage();
                executionVertex.getCurrentExecutionAttempt().registerProducedPartitions(logicalSlot.getTaskManagerLocation(), sendScheduleOrUpdateConsumerMessage);
                executionVertex.tryAssignResource((LogicalSlot)logicalSlot);
            } else {
                this.handleTaskDeploymentFailure(executionVertexId, DefaultScheduler.maybeWrapWithNoResourceAvailableException(throwable));
            }
            return null;
        };
    }

    private void releaseSlotIfPresent(@Nullable LogicalSlot logicalSlot) {
        if (logicalSlot != null) {
            logicalSlot.releaseSlot(null);
        }
    }

    private void handleTaskDeploymentFailure(ExecutionVertexID executionVertexId, Throwable error) {
        this.executionVertexOperations.markFailed(this.getExecutionVertex(executionVertexId), error);
    }

    private static Throwable maybeWrapWithNoResourceAvailableException(Throwable failure) {
        Throwable strippedThrowable = ExceptionUtils.stripCompletionException((Throwable)failure);
        if (strippedThrowable instanceof TimeoutException) {
            return new NoResourceAvailableException("Could not allocate the required slot within slot request timeout. Please make sure that the cluster has enough resources.", failure);
        }
        return failure;
    }

    private BiFunction<Object, Throwable, Void> deployOrHandleError(DeploymentHandle deploymentHandle) {
        ExecutionVertexVersion requiredVertexVersion = deploymentHandle.getRequiredVertexVersion();
        ExecutionVertexID executionVertexId = requiredVertexVersion.getExecutionVertexId();
        return (ignored, throwable) -> {
            if (this.executionVertexVersioner.isModified(requiredVertexVersion)) {
                this.log.debug("Refusing to deploy execution vertex {} because this deployment was superseded by another deployment", (Object)executionVertexId);
                return null;
            }
            if (throwable == null) {
                this.deployTaskSafe(executionVertexId);
            } else {
                this.handleTaskDeploymentFailure(executionVertexId, (Throwable)throwable);
            }
            return null;
        };
    }

    private void deployTaskSafe(ExecutionVertexID executionVertexId) {
        try {
            ExecutionVertex executionVertex = this.getExecutionVertex(executionVertexId);
            this.executionVertexOperations.deploy(executionVertex);
        }
        catch (Throwable e) {
            this.handleTaskDeploymentFailure(executionVertexId, e);
        }
    }

    private void notifyCoordinatorOfCancellation(ExecutionVertex vertex) {
        ExecutionState currentState = vertex.getExecutionState();
        if (currentState == ExecutionState.FAILED || currentState == ExecutionState.CANCELING || currentState == ExecutionState.CANCELED) {
            return;
        }
        for (OperatorCoordinator operatorCoordinator : vertex.getJobVertex().getOperatorCoordinators()) {
            operatorCoordinator.subtaskFailed(vertex.getParallelSubtaskIndex(), null);
        }
    }
}

