/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterables;

public class InputDependencyConstraintChecker {
    private final SchedulingIntermediateDataSetManager intermediateDataSetManager = new SchedulingIntermediateDataSetManager();

    public boolean check(SchedulingExecutionVertex schedulingExecutionVertex) {
        if (Iterables.isEmpty(schedulingExecutionVertex.getConsumedResults())) {
            return true;
        }
        InputDependencyConstraint inputConstraint = schedulingExecutionVertex.getInputDependencyConstraint();
        switch (inputConstraint) {
            case ANY: {
                return this.checkAny(schedulingExecutionVertex);
            }
            case ALL: {
                return this.checkAll(schedulingExecutionVertex);
            }
        }
        throw new IllegalStateException("Unknown InputDependencyConstraint " + inputConstraint);
    }

    List<SchedulingResultPartition> markSchedulingResultPartitionFinished(SchedulingResultPartition srp) {
        return this.intermediateDataSetManager.markSchedulingResultPartitionFinished(srp);
    }

    void resetSchedulingResultPartition(SchedulingResultPartition srp) {
        this.intermediateDataSetManager.resetSchedulingResultPartition(srp);
    }

    void addSchedulingResultPartition(SchedulingResultPartition srp) {
        this.intermediateDataSetManager.addSchedulingResultPartition(srp);
    }

    private boolean checkAll(SchedulingExecutionVertex schedulingExecutionVertex) {
        for (SchedulingResultPartition consumedResultPartition : schedulingExecutionVertex.getConsumedResults()) {
            if (this.partitionConsumable(consumedResultPartition)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAny(SchedulingExecutionVertex schedulingExecutionVertex) {
        for (SchedulingResultPartition consumedResultPartition : schedulingExecutionVertex.getConsumedResults()) {
            if (!this.partitionConsumable(consumedResultPartition)) continue;
            return true;
        }
        return false;
    }

    private boolean partitionConsumable(SchedulingResultPartition partition) {
        if (ResultPartitionType.BLOCKING.equals((Object)partition.getResultType())) {
            return this.intermediateDataSetManager.allPartitionsFinished(partition);
        }
        ResultPartitionState state = partition.getState();
        return ResultPartitionState.CONSUMABLE.equals((Object)state);
    }

    private static class SchedulingIntermediateDataSet {
        private final List<SchedulingResultPartition> partitions = new ArrayList<SchedulingResultPartition>();
        private final Set<IntermediateResultPartitionID> producingPartitionIds = new HashSet<IntermediateResultPartitionID>();

        SchedulingIntermediateDataSet() {
        }

        boolean markPartitionFinished(IntermediateResultPartitionID partitionId) {
            this.producingPartitionIds.remove(partitionId);
            return this.producingPartitionIds.isEmpty();
        }

        void resetPartition(IntermediateResultPartitionID partitionId) {
            this.producingPartitionIds.add(partitionId);
        }

        boolean allPartitionsFinished() {
            return this.producingPartitionIds.isEmpty();
        }

        void addSchedulingResultPartition(SchedulingResultPartition partition) {
            this.partitions.add(partition);
            this.producingPartitionIds.add((IntermediateResultPartitionID)partition.getId());
        }

        List<SchedulingResultPartition> getSchedulingResultPartitions() {
            return Collections.unmodifiableList(this.partitions);
        }
    }

    private static class SchedulingIntermediateDataSetManager {
        private final Map<IntermediateDataSetID, SchedulingIntermediateDataSet> intermediateDataSets = new HashMap<IntermediateDataSetID, SchedulingIntermediateDataSet>();

        private SchedulingIntermediateDataSetManager() {
        }

        List<SchedulingResultPartition> markSchedulingResultPartitionFinished(SchedulingResultPartition srp) {
            SchedulingIntermediateDataSet intermediateDataSet = this.getSchedulingIntermediateDataSet(srp.getResultId());
            if (intermediateDataSet.markPartitionFinished((IntermediateResultPartitionID)srp.getId())) {
                return intermediateDataSet.getSchedulingResultPartitions();
            }
            return Collections.emptyList();
        }

        void resetSchedulingResultPartition(SchedulingResultPartition srp) {
            SchedulingIntermediateDataSet sid = this.getSchedulingIntermediateDataSet(srp.getResultId());
            sid.resetPartition((IntermediateResultPartitionID)srp.getId());
        }

        void addSchedulingResultPartition(SchedulingResultPartition srp) {
            SchedulingIntermediateDataSet sid = this.getOrCreateSchedulingIntermediateDataSetIfAbsent(srp.getResultId());
            sid.addSchedulingResultPartition(srp);
        }

        boolean allPartitionsFinished(SchedulingResultPartition srp) {
            SchedulingIntermediateDataSet sid = this.getSchedulingIntermediateDataSet(srp.getResultId());
            return sid.allPartitionsFinished();
        }

        private SchedulingIntermediateDataSet getSchedulingIntermediateDataSet(IntermediateDataSetID intermediateDataSetId) {
            return this.getSchedulingIntermediateDataSetInternal(intermediateDataSetId, false);
        }

        private SchedulingIntermediateDataSet getOrCreateSchedulingIntermediateDataSetIfAbsent(IntermediateDataSetID intermediateDataSetId) {
            return this.getSchedulingIntermediateDataSetInternal(intermediateDataSetId, true);
        }

        private SchedulingIntermediateDataSet getSchedulingIntermediateDataSetInternal(IntermediateDataSetID intermediateDataSetId, boolean createIfAbsent) {
            return this.intermediateDataSets.computeIfAbsent(intermediateDataSetId, key -> {
                if (createIfAbsent) {
                    return new SchedulingIntermediateDataSet();
                }
                throw new IllegalArgumentException("can not find data set for " + intermediateDataSetId);
            });
        }
    }
}

