/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorage;

@PublicEvolving
public abstract class AbstractFileStateBackend
extends AbstractStateBackend {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final Path baseCheckpointPath;
    @Nullable
    private final Path baseSavepointPath;

    protected AbstractFileStateBackend(@Nullable URI baseCheckpointPath, @Nullable URI baseSavepointPath) {
        this(baseCheckpointPath == null ? null : new Path(baseCheckpointPath), baseSavepointPath == null ? null : new Path(baseSavepointPath));
    }

    protected AbstractFileStateBackend(@Nullable Path baseCheckpointPath, @Nullable Path baseSavepointPath) {
        this.baseCheckpointPath = baseCheckpointPath == null ? null : AbstractFileStateBackend.validatePath(baseCheckpointPath);
        this.baseSavepointPath = baseSavepointPath == null ? null : AbstractFileStateBackend.validatePath(baseSavepointPath);
    }

    protected AbstractFileStateBackend(@Nullable Path baseCheckpointPath, @Nullable Path baseSavepointPath, ReadableConfig configuration) {
        this(AbstractFileStateBackend.parameterOrConfigured(baseCheckpointPath, configuration, (ConfigOption<String>)CheckpointingOptions.CHECKPOINTS_DIRECTORY), AbstractFileStateBackend.parameterOrConfigured(baseSavepointPath, configuration, (ConfigOption<String>)CheckpointingOptions.SAVEPOINT_DIRECTORY));
    }

    @Nullable
    public Path getCheckpointPath() {
        return this.baseCheckpointPath;
    }

    @Nullable
    public Path getSavepointPath() {
        return this.baseSavepointPath;
    }

    @Override
    public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) throws IOException {
        return AbstractFsCheckpointStorage.resolveCheckpointPointer(pointer);
    }

    private static Path validatePath(Path path) {
        URI uri = path.toUri();
        String scheme = uri.getScheme();
        String pathPart = uri.getPath();
        if (scheme == null) {
            throw new IllegalArgumentException("The scheme (hdfs://, file://, etc) is null. Please specify the file system scheme explicitly in the URI.");
        }
        if (pathPart == null) {
            throw new IllegalArgumentException("The path to store the checkpoint data in is null. Please specify a directory path for the checkpoint data.");
        }
        if (pathPart.length() == 0 || pathPart.equals("/")) {
            throw new IllegalArgumentException("Cannot use the root directory for checkpoints.");
        }
        return path;
    }

    @Nullable
    private static Path parameterOrConfigured(@Nullable Path path, ReadableConfig config, ConfigOption<String> option) {
        if (path != null) {
            return path;
        }
        String configValue = (String)config.get(option);
        try {
            return configValue == null ? null : new Path(configValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalConfigurationException("Cannot parse value for " + option.key() + " : " + configValue + " . Not a valid path.");
        }
    }
}

