/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.ConfigurationException;
import akka.dispatch.ThreadPoolConfig$;
import akka.remote.transport.netty.NettyTransportSettings$Tcp$;
import akka.remote.transport.netty.NettyTransportSettings$Udp$;
import akka.remote.transport.netty.SSLSettings;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.net.InetAddress;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tMr!B\u0001\u0003\u0011\u0003Y\u0011A\u0006(fiRLHK]1ogB|'\u000f^*fiRLgnZ:\u000b\u0005\r!\u0011!\u00028fiRL(BA\u0003\u0007\u0003%!(/\u00198ta>\u0014HO\u0003\u0002\b\u0011\u00051!/Z7pi\u0016T\u0011!C\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003-9+G\u000f^=Ue\u0006t7\u000f]8siN+G\u000f^5oON\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1BB\u0004\u001b\u001bA\u0005\u0019\u0013E\u000e\u0003\t5{G-Z\n\u00033AI3!G\u000fa\r\u0015qR\u0002#! \u0005\r!6\r]\n\u0006;A\u0001#%\n\t\u0003Cei\u0011!\u0004\t\u0003#\rJ!\u0001\n\n\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011CJ\u0005\u0003OI\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQaF\u000f\u0005\u0002%\"\u0012A\u000b\t\u0003CuAQ\u0001L\u000f\u0005B5\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0005Y\u0006twMC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\u0002$AB*ue&tw\rC\u00048;\u0005\u0005I\u0011\t\u001d\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005q\u0003b\u0002\u001e\u001e\u0003\u0003%\taO\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002yA\u0011\u0011#P\u0005\u0003}I\u00111!\u00138u\u0011\u001d\u0001U$!A\u0005\u0002\u0005\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002C\u000bB\u0011\u0011cQ\u0005\u0003\tJ\u00111!\u00118z\u0011\u001d1u(!AA\u0002q\n1\u0001\u001f\u00132\u0011\u001dAU$!A\u0005B%\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0002\u0015B\u00191J\u0014\"\u000e\u00031S!!\u0014\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002P\u0019\nA\u0011\n^3sCR|'\u000fC\u0004R;\u0005\u0005I\u0011\u0001*\u0002\u0011\r\fg.R9vC2$\"a\u0015,\u0011\u0005E!\u0016BA+\u0013\u0005\u001d\u0011un\u001c7fC:DqA\u0012)\u0002\u0002\u0003\u0007!\tC\u0004Y;\u0005\u0005I\u0011I-\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u0010\u0005\b7v\t\t\u0011\"\u0003]\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003u\u0003\"a\f0\n\u0005}\u0003$AB(cU\u0016\u001cGOB\u0003b\u001b!\u0005%MA\u0002VIB\u001cR\u0001\u0019\t!E\u0015BQa\u00061\u0005\u0002\u0011$\u0012!\u001a\t\u0003C\u0001DQ\u0001\f1\u0005B5Bqa\u000e1\u0002\u0002\u0013\u0005\u0003\bC\u0004;A\u0006\u0005I\u0011A\u001e\t\u000f\u0001\u0003\u0017\u0011!C\u0001UR\u0011!i\u001b\u0005\b\r&\f\t\u00111\u0001=\u0011\u001dA\u0005-!A\u0005B%Cq!\u00151\u0002\u0002\u0013\u0005a\u000e\u0006\u0002T_\"9a)\\A\u0001\u0002\u0004\u0011\u0005b\u0002-a\u0003\u0003%\t%\u0017\u0005\b7\u0002\f\t\u0011\"\u0003]\u000f\u0015\u0019X\u0002#!+\u0003\r!6\r]\u0004\u0006k6A\t)Z\u0001\u0004+\u0012\u0004h\u0001\u0002\b\u0003\u0001]\u001c\"A\u001e\t\t\u0011e4(\u0011!Q\u0001\ni\faaY8oM&<\u0007cA>\u0002\u00045\tAP\u0003\u0002z{*\u0011ap`\u0001\tif\u0004Xm]1gK*\u0011\u0011\u0011A\u0001\u0004G>l\u0017bAA\u0003y\n11i\u001c8gS\u001eDaa\u0006<\u0005\u0002\u0005%A\u0003BA\u0006\u0003\u001b\u0001\"\u0001\u0004<\t\re\f9\u00011\u0001{\u0011%\t\tB\u001eb\u0001\n\u0003\t\u0019\"A\u0007Ue\u0006t7\u000f]8si6{G-Z\u000b\u0003\u0003+\u00012!a\u0006\u001a\u001d\r\tI\u0002\u0001\b\u0005\u00037\tiC\u0004\u0003\u0002\u001e\u0005-b\u0002BA\u0010\u0003SqA!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003KQ\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001\u0002\u0005\t\u0003c1\b\u0015!\u0003\u0002\u0016\u0005qAK]1ogB|'\u000f^'pI\u0016\u0004\u0003\"CA\u001bm\n\u0007I\u0011AA\u001c\u0003%)e.\u00192mKN\u001bH.F\u0001T\u0011\u001d\tYD\u001eQ\u0001\nM\u000b!\"\u00128bE2,7k\u001d7!\u0011%\tyD\u001eb\u0001\n\u0003\t\t%\u0001\u000eT'2+enZ5oKB\u0013xN^5eKJ\u001cE.Y:t\u001d\u0006lW-\u0006\u0002\u0002DA!\u0011QIA&\u001d\r\t\u0012qI\u0005\u0004\u0003\u0013\u0012\u0012A\u0002)sK\u0012,g-C\u00026\u0003\u001bR1!!\u0013\u0013\u0011!\t\tF\u001eQ\u0001\n\u0005\r\u0013aG*T\u0019\u0016sw-\u001b8f!J|g/\u001b3fe\u000ec\u0017m]:OC6,\u0007\u0005C\u0005\u0002VY\u0014\r\u0011\"\u0001\u0002X\u0005\u0011Rk]3ESN\u0004\u0018\r^2iKJ4uN]%p+\t\tI\u0006E\u0003\u0012\u00037\n\u0019%C\u0002\u0002^I\u0011aa\u00149uS>t\u0007\u0002CA1m\u0002\u0006I!!\u0017\u0002'U\u001bX\rR5ta\u0006$8\r[3s\r>\u0014\u0018j\u001c\u0011\t\u0011\u0005\u0015d\u000f)C\u0005\u0003O\n!b\u001c9uS>t7+\u001b>f)\u0011\tI'a\u001b\u0011\tE\tY\u0006\u0010\u0005\t\u0003[\n\u0019\u00071\u0001\u0002D\u0005\t1\u000fC\u0005\u0002rY\u0014\r\u0011\"\u0001\u0002t\u0005\t2i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;\u0016\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\tIV\u0014\u0018\r^5p]*\u0019\u0011q\u0010\n\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u0004\u0006e$A\u0004$j]&$X\rR;sCRLwN\u001c\u0005\t\u0003\u000f3\b\u0015!\u0003\u0002v\u0005\u00112i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;!\u0011%\tYI\u001eb\u0001\n\u0003\ti)\u0001\rXe&$XMQ;gM\u0016\u0014\b*[4i/\u0006$XM]'be.,\"!!\u001b\t\u0011\u0005Ee\u000f)A\u0005\u0003S\n\u0011d\u0016:ji\u0016\u0014UO\u001a4fe\"Kw\r[,bi\u0016\u0014X*\u0019:lA!I\u0011Q\u0013<C\u0002\u0013\u0005\u0011QR\u0001\u0018/JLG/\u001a\"vM\u001a,'\u000fT8x/\u0006$XM]'be.D\u0001\"!'wA\u0003%\u0011\u0011N\u0001\u0019/JLG/\u001a\"vM\u001a,'\u000fT8x/\u0006$XM]'be.\u0004\u0003\"CAOm\n\u0007I\u0011AAG\u00039\u0019VM\u001c3Ck\u001a4WM]*ju\u0016D\u0001\"!)wA\u0003%\u0011\u0011N\u0001\u0010'\u0016tGMQ;gM\u0016\u00148+\u001b>fA!I\u0011Q\u0015<C\u0002\u0013\u0005\u0011QR\u0001\u0012%\u0016\u001cW-\u001b<f\u0005V4g-\u001a:TSj,\u0007\u0002CAUm\u0002\u0006I!!\u001b\u0002%I+7-Z5wK\n+hMZ3s'&TX\r\t\u0005\t\u0003[3(\u0019!C\u0001w\u0005aQ*\u0019=Ge\u0006lWmU5{K\"9\u0011\u0011\u0017<!\u0002\u0013a\u0014!D'bq\u001a\u0013\u0018-\\3TSj,\u0007\u0005\u0003\u0005\u00026Z\u0014\r\u0011\"\u0001<\u0003\u001d\u0011\u0015mY6m_\u001eDq!!/wA\u0003%A(\u0001\u0005CC\u000e\\Gn\\4!\u0011%\tiL\u001eb\u0001\n\u0003\t9$\u0001\u0006UGBtu\u000eZ3mCfDq!!1wA\u0003%1+A\u0006UGBtu\u000eZ3mCf\u0004\u0003\"CAcm\n\u0007I\u0011AA\u001c\u00031!6\r]&fKB\fG.\u001b<f\u0011\u001d\tIM\u001eQ\u0001\nM\u000bQ\u0002V2q\u0017\u0016,\u0007/\u00197jm\u0016\u0004\u0003\"CAgm\n\u0007I\u0011AA\u001c\u00031!6\r\u001d*fkN,\u0017\t\u001a3s\u0011\u001d\t\tN\u001eQ\u0001\nM\u000bQ\u0002V2q%\u0016,8/Z!eIJ\u0004\u0003\"CAkm\n\u0007I\u0011AA!\u0003!Aun\u001d;oC6,\u0007\u0002CAmm\u0002\u0006I!a\u0011\u0002\u0013!{7\u000f\u001e8b[\u0016\u0004\u0003\"CAom\n\u0007I\u0011AA!\u00031\u0011\u0015N\u001c3I_N$h.Y7f\u0011!\t\tO\u001eQ\u0001\n\u0005\r\u0013!\u0004\"j]\u0012Dun\u001d;oC6,\u0007\u0005\u0003\u0005\u0002fZ\u0014\r\u0011\"\u0001<\u00031\u0001vN\u001d;TK2,7\r^8sQ!\t\u0019/!;\u0002p\u0006M\bcA\t\u0002l&\u0019\u0011Q\u001e\n\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002r\u0006\u0019t+\u0011*O\u0013:;%\b\t+iSN\u00043\u000f[8vY\u0012\u0004sN\u001c7zA\t,\u0007%^:fI\u0002\u0012\u0017\u0010\t9s_\u001a,7o]5p]\u0006d7OL\u0011\u0003\u0003k\f1A\r\u00181\u0011\u001d\tIP\u001eQ\u0001\nq\nQ\u0002U8siN+G.Z2u_J\u0004\u0003\u0002CA\u007fm\n\u0007I\u0011A\u001e\u0002!\tKg\u000e\u001a)peR\u001cV\r\\3di>\u0014\b\u0006CA~\u0003S\fyO!\u0001\"\u0005\t\r\u0011a\u0001\u001a/i!9!q\u0001<!\u0002\u0013a\u0014!\u0005\"j]\u0012\u0004vN\u001d;TK2,7\r^8sA!I!1\u0002<C\u0002\u0013\u0005!QB\u0001\f'Nd7+\u001a;uS:<7/\u0006\u0002\u0003\u0010A)\u0011#a\u0017\u0003\u0012A\u0019ABa\u0005\n\u0007\tU!AA\u0006T'2\u001bV\r\u001e;j]\u001e\u001c\b\u0002\u0003B\rm\u0002\u0006IAa\u0004\u0002\u0019M\u001bHnU3ui&twm\u001d\u0011\t\u0011\tuaO1A\u0005\u0002m\n!dU3sm\u0016\u00148k\\2lKR<vN]6feB{w\u000e\\*ju\u0016DqA!\twA\u0003%A(A\u000eTKJ4XM]*pG.,GoV8sW\u0016\u0014\bk\\8m'&TX\r\t\u0005\t\u0005K1(\u0019!C\u0001w\u0005Q2\t\\5f]R\u001cvnY6fi^{'o[3s!>|GnU5{K\"9!\u0011\u0006<!\u0002\u0013a\u0014aG\"mS\u0016tGoU8dW\u0016$xk\u001c:lKJ\u0004vn\u001c7TSj,\u0007\u0005C\u0004\u0003.Y$IAa\f\u0002\u0015\r|W\u000e];uK^\u00036\u000bF\u0002=\u0005cAa!\u001fB\u0016\u0001\u0004Q\b")
public class NettyTransportSettings {
    private final Config config;
    private final Mode TransportMode;
    private final boolean EnableSsl;
    private final String SSLEngineProviderClassName;
    private final Option<String> UseDispatcherForIo;
    private final FiniteDuration ConnectionTimeout;
    private final Option<Object> WriteBufferHighWaterMark;
    private final Option<Object> WriteBufferLowWaterMark;
    private final Option<Object> SendBufferSize;
    private final Option<Object> ReceiveBufferSize;
    private final int MaxFrameSize;
    private final int Backlog;
    private final boolean TcpNodelay;
    private final boolean TcpKeepalive;
    private final boolean TcpReuseAddr;
    private final String Hostname;
    private final String BindHostname;
    private final int PortSelector;
    private final int BindPortSelector;
    private final Option<SSLSettings> SslSettings;
    private final int ServerSocketWorkerPoolSize;
    private final int ClientSocketWorkerPoolSize;

    public Mode TransportMode() {
        return this.TransportMode;
    }

    public boolean EnableSsl() {
        return this.EnableSsl;
    }

    public String SSLEngineProviderClassName() {
        return this.SSLEngineProviderClassName;
    }

    public Option<String> UseDispatcherForIo() {
        return this.UseDispatcherForIo;
    }

    private Option<Object> optionSize(String s) {
        None$ none$;
        int n = (int)Predef$.MODULE$.Long2long(this.config.getBytes(s));
        switch (n) {
            default: {
                if (n < 0) {
                    throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting '", "' must be 0 or positive (and fit in an Int)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                }
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)n));
                break;
            }
            case 0: {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public FiniteDuration ConnectionTimeout() {
        return this.ConnectionTimeout;
    }

    public Option<Object> WriteBufferHighWaterMark() {
        return this.WriteBufferHighWaterMark;
    }

    public Option<Object> WriteBufferLowWaterMark() {
        return this.WriteBufferLowWaterMark;
    }

    public Option<Object> SendBufferSize() {
        return this.SendBufferSize;
    }

    public Option<Object> ReceiveBufferSize() {
        return this.ReceiveBufferSize;
    }

    public int MaxFrameSize() {
        return this.MaxFrameSize;
    }

    public int Backlog() {
        return this.Backlog;
    }

    public boolean TcpNodelay() {
        return this.TcpNodelay;
    }

    public boolean TcpKeepalive() {
        return this.TcpKeepalive;
    }

    public boolean TcpReuseAddr() {
        return this.TcpReuseAddr;
    }

    public String Hostname() {
        return this.Hostname;
    }

    public String BindHostname() {
        return this.BindHostname;
    }

    public int PortSelector() {
        return this.PortSelector;
    }

    public int BindPortSelector() {
        return this.BindPortSelector;
    }

    public Option<SSLSettings> SslSettings() {
        return this.SslSettings;
    }

    public int ServerSocketWorkerPoolSize() {
        return this.ServerSocketWorkerPoolSize;
    }

    public int ClientSocketWorkerPoolSize() {
        return this.ClientSocketWorkerPoolSize;
    }

    private int computeWPS(Config config) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("pool-size-min"), config.getDouble("pool-size-factor"), config.getInt("pool-size-max"));
    }

    private final Nothing$ throwInvalidNettyVersion$1(String nettyVersion$1) {
        throw new IllegalArgumentException(new StringBuilder().append((Object)"akka-remote with the Netty transport requires Netty version 3.10.6 or ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"later. Version [", "] is on the class path. Issue https://github.com/netty/netty/pull/4739 "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nettyVersion$1}))).append((Object)"may cause messages to not be delivered.").toString());
    }

    public NettyTransportSettings(Config config) {
        String string;
        block8: {
            Product product;
            block7: {
                block6: {
                    this.config = config;
                    string = config.getString("transport-protocol");
                    if (!"tcp".equals(string)) break block6;
                    product = NettyTransportSettings$Tcp$.MODULE$;
                    break block7;
                }
                if (!"udp".equals(string)) break block8;
                product = NettyTransportSettings$Udp$.MODULE$;
            }
            this.TransportMode = product;
            this.EnableSsl = BoxesRunTime.unboxToBoolean((Object)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToBoolean((boolean)config.getBoolean("enable-ssl"))), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransportSettings $outer;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(boolean x$1) {
                    if (!x$1) return true;
                    Mode mode = this.$outer.TransportMode();
                    NettyTransportSettings$Tcp$ nettyTransportSettings$Tcp$ = NettyTransportSettings$Tcp$.MODULE$;
                    if (mode == null) {
                        if (nettyTransportSettings$Tcp$ == null) return true;
                        return false;
                    } else if (mode.equals(nettyTransportSettings$Tcp$)) return true;
                    return false;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransportSettings $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not support SSL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.TransportMode()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            this.SSLEngineProviderClassName = this.EnableSsl() ? config.getString("ssl-engine-provider") : "";
            String string2 = config.getString("use-dispatcher-for-io");
            boolean bl = "".equals(string2) ? true : string2 == null;
            Object object = bl ? None$.MODULE$ : new Some((Object)string2);
            this.UseDispatcherForIo = object;
            this.ConnectionTimeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "connection-timeout");
            this.WriteBufferHighWaterMark = this.optionSize("write-buffer-high-water-mark");
            this.WriteBufferLowWaterMark = this.optionSize("write-buffer-low-water-mark");
            this.SendBufferSize = this.optionSize("send-buffer-size");
            this.ReceiveBufferSize = (Option)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(this.optionSize("receive-buffer-size")), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransportSettings $outer;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(Option<Object> s) {
                    if (s.isDefined()) return true;
                    Mode mode = this.$outer.TransportMode();
                    NettyTransportSettings$Udp$ nettyTransportSettings$Udp$ = NettyTransportSettings$Udp$.MODULE$;
                    if (mode != null) {
                        if (!mode.equals(nettyTransportSettings$Udp$)) return true;
                        return false;
                    }
                    if (nettyTransportSettings$Udp$ == null) return false;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "receive-buffer-size must be specified for UDP";
                }
            });
            this.MaxFrameSize = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Long2long(config.getBytes("maximum-frame-size"))))), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(int x$2) {
                    return this.apply$mcZI$sp(x$2);
                }

                public boolean apply$mcZI$sp(int x$2) {
                    return x$2 >= 32000;
                }
            }, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting 'maximum-frame-size' must be at least 32000 bytes"})).s((Seq)Nil$.MODULE$);
                }
            }));
            this.Backlog = config.getInt("backlog");
            this.TcpNodelay = config.getBoolean("tcp-nodelay");
            this.TcpKeepalive = config.getBoolean("tcp-keepalive");
            String string3 = config.getString("tcp-reuse-addr");
            boolean bl2 = "off-for-windows".equals(string3) ? !Helpers$.MODULE$.isWindows() : config.getBoolean("tcp-reuse-addr");
            this.TcpReuseAddr = bl2;
            String string4 = config.getString("hostname");
            String string5 = "".equals(string4) ? InetAddress.getLocalHost().getHostAddress() : string4;
            this.Hostname = string5;
            String string6 = config.getString("bind-hostname");
            String string7 = "".equals(string6) ? this.Hostname() : string6;
            this.BindHostname = string7;
            this.PortSelector = config.getInt("port");
            String string8 = config.getString("bind-port");
            int n = "".equals(string8) ? this.PortSelector() : new StringOps(Predef$.MODULE$.augmentString(string8)).toInt();
            this.BindPortSelector = n;
            this.SslSettings = this.EnableSsl() ? new Some((Object)new SSLSettings(config.getConfig("security"))) : None$.MODULE$;
            this.ServerSocketWorkerPoolSize = this.computeWPS(config.getConfig("server-socket-worker-pool"));
            this.ClientSocketWorkerPoolSize = this.computeWPS(config.getConfig("client-socket-worker-pool"));
            String nettyVersion = "3.10.6.Final-5f56a03";
            try {
                String[] segments = nettyVersion.split("[.-]");
                if (segments.length < 3 || new StringOps(Predef$.MODULE$.augmentString(segments[0])).toInt() != 3 || new StringOps(Predef$.MODULE$.augmentString(segments[1])).toInt() != 10 || new StringOps(Predef$.MODULE$.augmentString(segments[2])).toInt() < 6) {
                    throw this.throwInvalidNettyVersion$1(nettyVersion);
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.throwInvalidNettyVersion$1(nettyVersion);
            }
        }
        throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown transport: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public static interface Mode {
    }
}

