/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.runtime.checkpoint.Checkpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CheckpointsCleaner
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointsCleaner.class);
    private final AtomicInteger numberOfCheckpointsToClean = new AtomicInteger(0);

    int getNumberOfCheckpointsToClean() {
        return this.numberOfCheckpointsToClean.get();
    }

    public void cleanCheckpoint(Checkpoint checkpoint, boolean shouldDiscard, Runnable postCleanAction, Executor executor) {
        this.numberOfCheckpointsToClean.incrementAndGet();
        executor.execute(() -> {
            try {
                if (shouldDiscard) {
                    try {
                        checkpoint.discard();
                    }
                    catch (Exception e) {
                        LOG.warn("Could not discard completed checkpoint {}.", (Object)checkpoint.getCheckpointID(), (Object)e);
                    }
                }
            }
            finally {
                this.numberOfCheckpointsToClean.decrementAndGet();
                postCleanAction.run();
            }
        });
    }
}

