/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.apache.flink.util.Preconditions;

public class InflightDataRescalingDescriptor
implements Serializable {
    public static final InflightDataRescalingDescriptor NO_RESCALE = new NoRescalingDescriptor();
    private static final long serialVersionUID = -3396674344669796295L;
    private final int[] oldSubtaskIndexes;
    private final RescaleMappings[] rescaledChannelsMappings;
    private final Set<Integer> ambiguousSubtaskIndexes;

    public InflightDataRescalingDescriptor(int[] oldSubtaskIndexes, RescaleMappings[] rescaledChannelsMappings, Set<Integer> ambiguousSubtaskIndexes) {
        this.oldSubtaskIndexes = (int[])Preconditions.checkNotNull((Object)oldSubtaskIndexes);
        this.rescaledChannelsMappings = (RescaleMappings[])Preconditions.checkNotNull((Object)rescaledChannelsMappings);
        this.ambiguousSubtaskIndexes = (Set)Preconditions.checkNotNull(ambiguousSubtaskIndexes);
    }

    public int[] getOldSubtaskIndexes() {
        return this.oldSubtaskIndexes;
    }

    public RescaleMappings getChannelMapping(int gateOrPartitionIndex) {
        return this.rescaledChannelsMappings[gateOrPartitionIndex];
    }

    public boolean isAmbiguous(int oldSubtaskIndex) {
        return this.ambiguousSubtaskIndexes.contains(oldSubtaskIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InflightDataRescalingDescriptor that = (InflightDataRescalingDescriptor)o;
        return Arrays.equals(this.oldSubtaskIndexes, that.oldSubtaskIndexes) && Arrays.equals(this.rescaledChannelsMappings, that.rescaledChannelsMappings) && Objects.equals(this.ambiguousSubtaskIndexes, that.ambiguousSubtaskIndexes);
    }

    public int hashCode() {
        int result = Objects.hash(this.ambiguousSubtaskIndexes);
        result = 31 * result + Arrays.hashCode(this.oldSubtaskIndexes);
        result = 31 * result + Arrays.hashCode(this.rescaledChannelsMappings);
        return result;
    }

    public String toString() {
        return "InflightDataRescalingDescriptor{oldSubtaskIndexes=" + Arrays.toString(this.oldSubtaskIndexes) + ", rescaledChannelsMappings=" + Arrays.toString(this.rescaledChannelsMappings) + ", ambiguousSubtaskIndexes=" + this.ambiguousSubtaskIndexes + '}';
    }

    private static class NoRescalingDescriptor
    extends InflightDataRescalingDescriptor {
        private static final long serialVersionUID = -5544173933105855751L;

        public NoRescalingDescriptor() {
            super(new int[0], new RescaleMappings[0], Collections.emptySet());
        }

        @Override
        public RescaleMappings getChannelMapping(int gateOrPartitionIndex) {
            return RescaleMappings.SYMMETRIC_IDENTITY;
        }

        private Object readResolve() throws ObjectStreamException {
            return NO_RESCALE;
        }

        @Override
        public String toString() {
            return "NoRescalingDescriptor";
        }
    }
}

