/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptor;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterators;
import org.apache.flink.util.Preconditions;

public class TaskStateSnapshot
implements CompositeStateHandle {
    private static final long serialVersionUID = 1L;
    private final Map<OperatorID, OperatorSubtaskState> subtaskStatesByOperatorID;

    public TaskStateSnapshot() {
        this(10);
    }

    public TaskStateSnapshot(int size) {
        this(new HashMap<OperatorID, OperatorSubtaskState>(size));
    }

    public TaskStateSnapshot(Map<OperatorID, OperatorSubtaskState> subtaskStatesByOperatorID) {
        this.subtaskStatesByOperatorID = (Map)Preconditions.checkNotNull(subtaskStatesByOperatorID);
    }

    @Nullable
    public OperatorSubtaskState getSubtaskStateByOperatorID(OperatorID operatorID) {
        return this.subtaskStatesByOperatorID.get((Object)operatorID);
    }

    public OperatorSubtaskState putSubtaskStateByOperatorID(@Nonnull OperatorID operatorID, @Nonnull OperatorSubtaskState state) {
        return this.subtaskStatesByOperatorID.put(operatorID, (OperatorSubtaskState)Preconditions.checkNotNull((Object)state));
    }

    public Set<Map.Entry<OperatorID, OperatorSubtaskState>> getSubtaskStateMappings() {
        return this.subtaskStatesByOperatorID.entrySet();
    }

    public boolean hasState() {
        for (OperatorSubtaskState operatorSubtaskState : this.subtaskStatesByOperatorID.values()) {
            if (operatorSubtaskState == null || !operatorSubtaskState.hasState()) continue;
            return true;
        }
        return false;
    }

    public InflightDataRescalingDescriptor getInputRescalingDescriptor() {
        return this.getMapping(OperatorSubtaskState::getInputRescalingDescriptor);
    }

    public InflightDataRescalingDescriptor getOutputRescalingDescriptor() {
        return this.getMapping(OperatorSubtaskState::getOutputRescalingDescriptor);
    }

    @Override
    public void discardState() throws Exception {
        StateUtil.bestEffortDiscardAllStateObjects(this.subtaskStatesByOperatorID.values());
    }

    @Override
    public long getStateSize() {
        long size = 0L;
        for (OperatorSubtaskState subtaskState : this.subtaskStatesByOperatorID.values()) {
            if (subtaskState == null) continue;
            size += subtaskState.getStateSize();
        }
        return size;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
        for (OperatorSubtaskState operatorSubtaskState : this.subtaskStatesByOperatorID.values()) {
            if (operatorSubtaskState == null) continue;
            operatorSubtaskState.registerSharedStates(stateRegistry);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStateSnapshot that = (TaskStateSnapshot)o;
        return this.subtaskStatesByOperatorID.equals(that.subtaskStatesByOperatorID);
    }

    public int hashCode() {
        return this.subtaskStatesByOperatorID.hashCode();
    }

    public String toString() {
        return "TaskOperatorSubtaskStates{subtaskStatesByOperatorID=" + this.subtaskStatesByOperatorID + '}';
    }

    private InflightDataRescalingDescriptor getMapping(Function<OperatorSubtaskState, InflightDataRescalingDescriptor> mappingExtractor) {
        return (InflightDataRescalingDescriptor)Iterators.getOnlyElement(this.subtaskStatesByOperatorID.values().stream().map(mappingExtractor).filter(mapping -> !mapping.equals(InflightDataRescalingDescriptor.NO_RESCALE)).iterator(), (Object)InflightDataRescalingDescriptor.NO_RESCALE);
    }
}

