/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.DispatcherBootstrapFactory;
import org.apache.flink.runtime.dispatcher.DispatcherFactory;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.DispatcherServices;
import org.apache.flink.runtime.dispatcher.JobMasterServiceLeadershipRunnerFactory;
import org.apache.flink.runtime.dispatcher.MiniDispatcher;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServicesWithJobGraphStore;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterables;

public enum JobDispatcherFactory implements DispatcherFactory
{
    INSTANCE;


    @Override
    public MiniDispatcher createDispatcher(RpcService rpcService, DispatcherId fencingToken, Collection<JobGraph> recoveredJobs, DispatcherBootstrapFactory dispatcherBootstrapFactory, PartialDispatcherServicesWithJobGraphStore partialDispatcherServicesWithJobGraphStore) throws Exception {
        JobGraph jobGraph = (JobGraph)Iterables.getOnlyElement(recoveredJobs);
        Configuration configuration = partialDispatcherServicesWithJobGraphStore.getConfiguration();
        String executionModeValue = configuration.getString(ClusterEntrypoint.INTERNAL_CLUSTER_EXECUTION_MODE);
        ClusterEntrypoint.ExecutionMode executionMode = ClusterEntrypoint.ExecutionMode.valueOf(executionModeValue);
        return new MiniDispatcher(rpcService, fencingToken, DispatcherServices.from(partialDispatcherServicesWithJobGraphStore, JobMasterServiceLeadershipRunnerFactory.INSTANCE), jobGraph, dispatcherBootstrapFactory, executionMode);
    }
}

