/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriver;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalEventHandler;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLeaderRetrievalService
implements LeaderRetrievalService,
LeaderRetrievalEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLeaderRetrievalService.class);
    private final Object lock = new Object();
    private final LeaderRetrievalDriverFactory leaderRetrievalDriverFactory;
    @Nullable
    @GuardedBy(value="lock")
    private String lastLeaderAddress;
    @Nullable
    @GuardedBy(value="lock")
    private UUID lastLeaderSessionID;
    @GuardedBy(value="lock")
    private volatile boolean running;
    private volatile LeaderRetrievalListener leaderListener;
    private LeaderRetrievalDriver leaderRetrievalDriver;

    public DefaultLeaderRetrievalService(LeaderRetrievalDriverFactory leaderRetrievalDriverFactory) {
        this.leaderRetrievalDriverFactory = (LeaderRetrievalDriverFactory)Preconditions.checkNotNull((Object)leaderRetrievalDriverFactory);
        this.lastLeaderAddress = null;
        this.lastLeaderSessionID = null;
        this.leaderRetrievalDriver = null;
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(LeaderRetrievalListener listener) throws Exception {
        Preconditions.checkNotNull((Object)listener, (String)"Listener must not be null.");
        Preconditions.checkState((this.leaderListener == null ? 1 : 0) != 0, (Object)"DefaultLeaderRetrievalService can only be started once.");
        Object object = this.lock;
        synchronized (object) {
            this.leaderListener = listener;
            this.leaderRetrievalDriver = this.leaderRetrievalDriverFactory.createLeaderRetrievalDriver(this, new LeaderRetrievalFatalErrorHandler());
            LOG.info("Starting DefaultLeaderRetrievalService with {}.", (Object)this.leaderRetrievalDriver);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        LOG.info("Stopping DefaultLeaderRetrievalService.");
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.running = false;
        }
        this.leaderRetrievalDriver.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void notifyLeaderAddress(LeaderInformation leaderInformation) {
        UUID newLeaderSessionID = leaderInformation.getLeaderSessionID();
        String newLeaderAddress = leaderInformation.getLeaderAddress();
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                if (!Objects.equals(newLeaderAddress, this.lastLeaderAddress) || !Objects.equals(newLeaderSessionID, this.lastLeaderSessionID)) {
                    if (LOG.isDebugEnabled()) {
                        if (newLeaderAddress == null && newLeaderSessionID == null) {
                            LOG.debug("Leader information was lost: The listener will be notified accordingly.");
                        } else {
                            LOG.debug("New leader information: Leader={}, session ID={}.", (Object)newLeaderAddress, (Object)newLeaderSessionID);
                        }
                    }
                    this.lastLeaderAddress = newLeaderAddress;
                    this.lastLeaderSessionID = newLeaderSessionID;
                    this.leaderListener.notifyLeaderAddress(newLeaderAddress, newLeaderSessionID);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring notification since the {} has already been closed.", (Object)this.leaderRetrievalDriver);
            }
        }
    }

    private class LeaderRetrievalFatalErrorHandler
    implements FatalErrorHandler {
        private LeaderRetrievalFatalErrorHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFatalError(Throwable throwable) {
            Object object = DefaultLeaderRetrievalService.this.lock;
            synchronized (object) {
                if (!DefaultLeaderRetrievalService.this.running) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring error notification since the service has been stopped.");
                    }
                    return;
                }
                if (throwable instanceof LeaderRetrievalException) {
                    DefaultLeaderRetrievalService.this.leaderListener.handleError((Exception)((Object)((LeaderRetrievalException)((Object)throwable))));
                } else {
                    DefaultLeaderRetrievalService.this.leaderListener.handleError((Exception)((Object)new LeaderRetrievalException(throwable)));
                }
            }
        }
    }
}

