/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.management;

import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import org.apache.flink.runtime.management.JMXServer;
import org.apache.flink.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXService {
    private static final Logger LOG = LoggerFactory.getLogger(JMXService.class);
    private static JMXServer jmxServer = null;

    public static Optional<JMXServer> getInstance() {
        return Optional.ofNullable(jmxServer);
    }

    public static synchronized void startInstance(String portsConfig) {
        if (jmxServer == null) {
            if (portsConfig != null) {
                Iterator ports = NetUtils.getPortRangeFromString((String)portsConfig);
                if (ports.hasNext()) {
                    jmxServer = JMXService.startJMXServerWithPortRanges(ports);
                }
                if (jmxServer == null) {
                    LOG.error("Could not start JMX server on any configured port(s) in: " + portsConfig);
                }
            }
        } else {
            LOG.warn("JVM-wide JMXServer already started at port: " + jmxServer.getPort());
        }
    }

    public static synchronized void stopInstance() throws IOException {
        if (jmxServer != null) {
            jmxServer.stop();
            jmxServer = null;
        }
    }

    public static synchronized Optional<Integer> getPort() {
        return Optional.ofNullable(jmxServer).map(JMXServer::getPort);
    }

    private static JMXServer startJMXServerWithPortRanges(Iterator<Integer> ports) {
        JMXServer successfullyStartedServer = null;
        while (ports.hasNext() && successfullyStartedServer == null) {
            JMXServer server = new JMXServer();
            int port = ports.next();
            try {
                server.start(port);
                LOG.info("Started JMX server on port " + port + ".");
                successfullyStartedServer = server;
            }
            catch (IOException ioe) {
                LOG.debug("Could not start JMX server on port " + port + ".", (Throwable)ioe);
                try {
                    server.stop();
                }
                catch (Exception e) {
                    LOG.debug("Could not stop JMX server.", (Throwable)e);
                }
            }
        }
        return successfullyStartedServer;
    }
}

